% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{splitLine}
\alias{splitLine}
\title{Split line with line breaks depending on max.width}
\usage{
splitLine(x, max.width = panderOptions("table.split.cells"),
  use.hyphening = FALSE)
}
\arguments{
\item{x}{string to be split. Works only with one string. Non-string arguments and multi-dimensional arguments are returned unchaged}

\item{max.width}{default integer value specyfing max number of characters between line breaks}

\item{use.hyphening}{(default: \code{FALSE}) if try to use hyphening when splitting large cells according to table.split.cells. Requires \pkg{sylly}.}
}
\value{
character string with line breaks
}
\description{
This is a helper function to insert line breaks depending on (\code{split.cells} parameter of \code{pandoc.table}) of the returning table.
}
\examples{
splitLine('foo bar', 6)
splitLine('foo bar', 7)
splitLine('Pandoc Package', 3, TRUE)
}
