# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ActionRulesOperations:
    """ActionRulesOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.alertsmanagement.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def list_by_subscription(
        self,
        target_resource_group: Optional[str] = None,
        target_resource_type: Optional[str] = None,
        target_resource: Optional[str] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        monitor_service: Optional[Union[str, "_models.MonitorService"]] = None,
        impacted_scope: Optional[str] = None,
        description: Optional[str] = None,
        alert_rule_id: Optional[str] = None,
        action_group: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ) -> AsyncIterable["_models.ActionRulesList"]:
        """Get all action rule in a given subscription.

        List all action rules of the subscription and given input filters.

        :param target_resource_group: Filter by target resource group name. Default value is select
         all.
        :type target_resource_group: str
        :param target_resource_type: Filter by target resource type. Default value is select all.
        :type target_resource_type: str
        :param target_resource: Filter by target resource( which is full ARM ID) Default value is
         select all.
        :type target_resource: str
        :param severity: Filter by severity.  Default value is select all.
        :type severity: str or ~azure.mgmt.alertsmanagement.models.Severity
        :param monitor_service: Filter by monitor service which generates the alert instance. Default
         value is select all.
        :type monitor_service: str or ~azure.mgmt.alertsmanagement.models.MonitorService
        :param impacted_scope: filter by impacted/target scope (provide comma separated list for
         multiple scopes). The value should be an well constructed ARM id of the scope.
        :type impacted_scope: str
        :param description: filter by alert rule description.
        :type description: str
        :param alert_rule_id: filter by alert rule id.
        :type alert_rule_id: str
        :param action_group: filter by action group configured as part of action rule.
        :type action_group: str
        :param name: filter by action rule name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ActionRulesList or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.alertsmanagement.models.ActionRulesList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType["_models.ActionRulesList"]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

            if not next_link:
                # Construct URL
                url = self.list_by_subscription.metadata["url"]  # type: ignore
                path_format_arguments = {
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
                    ),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if target_resource_group is not None:
                    query_parameters["targetResourceGroup"] = self._serialize.query(
                        "target_resource_group", target_resource_group, "str"
                    )
                if target_resource_type is not None:
                    query_parameters["targetResourceType"] = self._serialize.query(
                        "target_resource_type", target_resource_type, "str"
                    )
                if target_resource is not None:
                    query_parameters["targetResource"] = self._serialize.query(
                        "target_resource", target_resource, "str"
                    )
                if severity is not None:
                    query_parameters["severity"] = self._serialize.query("severity", severity, "str")
                if monitor_service is not None:
                    query_parameters["monitorService"] = self._serialize.query(
                        "monitor_service", monitor_service, "str"
                    )
                if impacted_scope is not None:
                    query_parameters["impactedScope"] = self._serialize.query("impacted_scope", impacted_scope, "str")
                if description is not None:
                    query_parameters["description"] = self._serialize.query("description", description, "str")
                if alert_rule_id is not None:
                    query_parameters["alertRuleId"] = self._serialize.query("alert_rule_id", alert_rule_id, "str")
                if action_group is not None:
                    query_parameters["actionGroup"] = self._serialize.query("action_group", action_group, "str")
                if name is not None:
                    query_parameters["name"] = self._serialize.query("name", name, "str")
                query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ActionRulesList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(_models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_subscription.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/actionRules"}  # type: ignore

    def list_by_resource_group(
        self,
        resource_group_name: str,
        target_resource_group: Optional[str] = None,
        target_resource_type: Optional[str] = None,
        target_resource: Optional[str] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        monitor_service: Optional[Union[str, "_models.MonitorService"]] = None,
        impacted_scope: Optional[str] = None,
        description: Optional[str] = None,
        alert_rule_id: Optional[str] = None,
        action_group: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ) -> AsyncIterable["_models.ActionRulesList"]:
        """Get all action rules created in a resource group.

        List all action rules of the subscription, created in given resource group and given input
        filters.

        :param resource_group_name: Resource group name where the resource is created.
        :type resource_group_name: str
        :param target_resource_group: Filter by target resource group name. Default value is select
         all.
        :type target_resource_group: str
        :param target_resource_type: Filter by target resource type. Default value is select all.
        :type target_resource_type: str
        :param target_resource: Filter by target resource( which is full ARM ID) Default value is
         select all.
        :type target_resource: str
        :param severity: Filter by severity.  Default value is select all.
        :type severity: str or ~azure.mgmt.alertsmanagement.models.Severity
        :param monitor_service: Filter by monitor service which generates the alert instance. Default
         value is select all.
        :type monitor_service: str or ~azure.mgmt.alertsmanagement.models.MonitorService
        :param impacted_scope: filter by impacted/target scope (provide comma separated list for
         multiple scopes). The value should be an well constructed ARM id of the scope.
        :type impacted_scope: str
        :param description: filter by alert rule description.
        :type description: str
        :param alert_rule_id: filter by alert rule id.
        :type alert_rule_id: str
        :param action_group: filter by action group configured as part of action rule.
        :type action_group: str
        :param name: filter by action rule name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ActionRulesList or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.alertsmanagement.models.ActionRulesList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType["_models.ActionRulesList"]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

            if not next_link:
                # Construct URL
                url = self.list_by_resource_group.metadata["url"]  # type: ignore
                path_format_arguments = {
                    "subscriptionId": self._serialize.url(
                        "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
                    ),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, "str"),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if target_resource_group is not None:
                    query_parameters["targetResourceGroup"] = self._serialize.query(
                        "target_resource_group", target_resource_group, "str"
                    )
                if target_resource_type is not None:
                    query_parameters["targetResourceType"] = self._serialize.query(
                        "target_resource_type", target_resource_type, "str"
                    )
                if target_resource is not None:
                    query_parameters["targetResource"] = self._serialize.query(
                        "target_resource", target_resource, "str"
                    )
                if severity is not None:
                    query_parameters["severity"] = self._serialize.query("severity", severity, "str")
                if monitor_service is not None:
                    query_parameters["monitorService"] = self._serialize.query(
                        "monitor_service", monitor_service, "str"
                    )
                if impacted_scope is not None:
                    query_parameters["impactedScope"] = self._serialize.query("impacted_scope", impacted_scope, "str")
                if description is not None:
                    query_parameters["description"] = self._serialize.query("description", description, "str")
                if alert_rule_id is not None:
                    query_parameters["alertRuleId"] = self._serialize.query("alert_rule_id", alert_rule_id, "str")
                if action_group is not None:
                    query_parameters["actionGroup"] = self._serialize.query("action_group", action_group, "str")
                if name is not None:
                    query_parameters["name"] = self._serialize.query("name", name, "str")
                query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ActionRulesList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(_models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules"}  # type: ignore

    async def get_by_name(self, resource_group_name: str, action_rule_name: str, **kwargs) -> "_models.ActionRule":
        """Get action rule by name.

        Get a specific action rule.

        :param resource_group_name: Resource group name where the resource is created.
        :type resource_group_name: str
        :param action_rule_name: The name of action rule that needs to be fetched.
        :type action_rule_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ActionRule, or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.ActionRule
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType["_models.ActionRule"]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_by_name.metadata["url"]  # type: ignore
        path_format_arguments = {
            "subscriptionId": self._serialize.url(
                "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
            ),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, "str"),
            "actionRuleName": self._serialize.url("action_rule_name", action_rule_name, "str"),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        deserialized = self._deserialize("ActionRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_by_name.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}"}  # type: ignore

    async def create_update(
        self, resource_group_name: str, action_rule_name: str, action_rule: "_models.ActionRule", **kwargs
    ) -> "_models.ActionRule":
        """Create/update an action rule.

        Creates/Updates a specific action rule.

        :param resource_group_name: Resource group name where the resource is created.
        :type resource_group_name: str
        :param action_rule_name: The name of action rule that needs to be created/updated.
        :type action_rule_name: str
        :param action_rule: action rule to be created/updated.
        :type action_rule: ~azure.mgmt.alertsmanagement.models.ActionRule
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ActionRule, or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.ActionRule
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType["_models.ActionRule"]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.create_update.metadata["url"]  # type: ignore
        path_format_arguments = {
            "subscriptionId": self._serialize.url(
                "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
            ),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, "str"),
            "actionRuleName": self._serialize.url("action_rule_name", action_rule_name, "str"),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters["Content-Type"] = self._serialize.header("content_type", content_type, "str")
        header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(action_rule, "ActionRule")
        body_content_kwargs["content"] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        deserialized = self._deserialize("ActionRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    create_update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}"}  # type: ignore

    async def delete(self, resource_group_name: str, action_rule_name: str, **kwargs) -> bool:
        """Delete action rule.

        Deletes a given action rule.

        :param resource_group_name: Resource group name where the resource is created.
        :type resource_group_name: str
        :param action_rule_name: The name that needs to be deleted.
        :type action_rule_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[bool]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        accept = "application/json"

        # Construct URL
        url = self.delete.metadata["url"]  # type: ignore
        path_format_arguments = {
            "subscriptionId": self._serialize.url(
                "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
            ),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, "str"),
            "actionRuleName": self._serialize.url("action_rule_name", action_rule_name, "str"),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        deserialized = self._deserialize("bool", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}"}  # type: ignore

    async def update(
        self, resource_group_name: str, action_rule_name: str, action_rule_patch: "_models.PatchObject", **kwargs
    ) -> "_models.ActionRule":
        """Patch action rule.

        Update enabled flag and/or tags for the given action rule.

        :param resource_group_name: Resource group name where the resource is created.
        :type resource_group_name: str
        :param action_rule_name: The name that needs to be updated.
        :type action_rule_name: str
        :param action_rule_patch: Parameters supplied to the operation.
        :type action_rule_patch: ~azure.mgmt.alertsmanagement.models.PatchObject
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ActionRule, or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.ActionRule
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType["_models.ActionRule"]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))
        api_version = "2019-05-05-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.update.metadata["url"]  # type: ignore
        path_format_arguments = {
            "subscriptionId": self._serialize.url(
                "self._config.subscription_id", self._config.subscription_id, "str", min_length=1
            ),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, "str"),
            "actionRuleName": self._serialize.url("action_rule_name", action_rule_name, "str"),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters["api-version"] = self._serialize.query("api_version", api_version, "str")

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters["Content-Type"] = self._serialize.header("content_type", content_type, "str")
        header_parameters["Accept"] = self._serialize.header("accept", accept, "str")

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(action_rule_patch, "PatchObject")
        body_content_kwargs["content"] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        deserialized = self._deserialize("ActionRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}"}  # type: ignore
