
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramFlagsAttributes.h
    \\brief Definition of MetgramFlags Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "MetgramFlagsWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


MetgramFlagsWrapper::MetgramFlagsWrapper(): metgramflags_(new MetgramFlags())

{

	
	
	
} 
MetgramFlagsWrapper::MetgramFlagsWrapper(MetgramFlags* metgramflags): metgramflags_(metgramflags)
{
	
	
} 

MetgramFlagsWrapper::~MetgramFlagsWrapper()
{
	
}

void MetgramFlagsWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("METGRAM_FLAG_FREQUENCY") ) {
		int frequency_value = request("METGRAM_FLAG_FREQUENCY");
		metgramflags_->frequency_ = frequency_value;
		}
	if  (request.countValues("METGRAM_FLAG_METHOD") ) {
		string method_value = request("METGRAM_FLAG_METHOD");
		metgramflags_->method_ = method_value;
		}
	if  (request.countValues("METGRAM_FLAG_COMPONENT1") ) {
		string component1_value = request("METGRAM_FLAG_COMPONENT1");
		metgramflags_->component1_ = component1_value;
		}
	if  (request.countValues("METGRAM_FLAG_COMPONENT2") ) {
		string component2_value = request("METGRAM_FLAG_COMPONENT2");
		metgramflags_->component2_ = component2_value;
		}
	if  (request.countValues("METGRAM_FLAG_LENGTH") ) {
		double length_value = request("METGRAM_FLAG_LENGTH");
		metgramflags_->length_ = length_value;
		}
	
	if  (request.countValues("METGRAM_FLAG_COLOUR") ) {
		string colour_value = request("METGRAM_FLAG_COLOUR");
		metgramflags_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
}

void MetgramFlagsWrapper::print(ostream& out)  const
{
	out << "MetgramFlagsWrapper[]";
}


    




