
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CalculateColourTechniqueAttributes.h
    \\brief Definition of CalculateColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "CalculateColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CalculateColourTechniqueAttributes::CalculateColourTechniqueAttributes():
	direction_(ParameterManager::getString("contour_shade_colour_direction"))
	,
	max_(MagTranslator<string, Colour>().magics("contour_shade_max_level_colour")),
	min_(MagTranslator<string, Colour>().magics("contour_shade_min_level_colour"))
	 
{
} 


CalculateColourTechniqueAttributes::~CalculateColourTechniqueAttributes()
{
	
}

    
void CalculateColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	setAttribute(prefix, "contour_shade_colour_direction", direction_, params);
	
	setMember(prefix, "contour_shade_max_level_colour", max_, params);
	setMember(prefix, "contour_shade_min_level_colour", min_, params);
	
}

void CalculateColourTechniqueAttributes::copy(const CalculateColourTechniqueAttributes& other)
{
	direction_ = other.direction_;
	max_ = unique_ptr<Colour>(other.max_->clone());
	min_ = unique_ptr<Colour>(other.min_->clone());
	
} 


bool CalculateColourTechniqueAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "calculate")  )
		return true;
	
	return false;
}

void CalculateColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "calculate")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CalculateColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " direction = " <<  direction_;
	out << " max = " <<  *max_;
	out << " min = " <<  *min_;
	
	out << "]" << "\n";
}

void CalculateColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"calculate\""; 
	out << ", \"contour_shade_colour_direction\":";
	niceprint(out,direction_);
	out << ", \"contour_shade_max_level_colour\":";
	niceprint(out, *max_);
	out << ", \"contour_shade_min_level_colour\":";
	niceprint(out, *min_);
	
}

static MagicsParameter<string> contour_shade_colour_direction("contour_shade_colour_direction", "anti_clockwise", "");
static MagicsParameter<string> contour_shade_max_level_colour("contour_shade_max_level_colour", "blue", ""); 
static MagicsParameter<string> contour_shade_min_level_colour("contour_shade_min_level_colour", "red", ""); 
