---
title: "Jekyll 3.7.2 Released"
date: 2018-01-25 22:22:22 +0530
author: ashmaroli
version: 3.7.2
categories: [release]
---

Close on the heels of shipping 3.7.0, we were informed of a couple of
regressions due to the changes made in that release. In due time, Team Jekyll
set out to address those issues as early as possible.

Days later here we're, announcing 3.7.2 (sorry for skipping 3.7.1, 
RubyGems didn't want to play nice) that fixes numerous issues! :tada:
The highlights being:

  * A major regression in 3.7.0 was that when a Front Matter Default was
    configured with a `scope["path"]` set to a directory, Jekyll would scan
    that directory for any subfolders and files, for each document in that
    `path`.
    Though this is intended, it increases build times in proportion to the size
    of the directory.

    We addressed this by having Jekyll scan the directory path only if the user
    explicitly configures the `scope["path"]` using wildcards.

    Read our [documentation](/docs/configuration/#glob-patterns-in-front-matter-defaults)
    for more details.

    A huge shout-out to @mmistakes for bringing this to our notice and
    additionally providing us with a test repository to aid in resolving the issue.

  * Another regression reported was related to our "Custom collections
    directory" feature introduced in 3.7.0.

    Users setting `collection_dir` to a certain directory would have *altered*
    paths to their posts still at the root of their site's source. This
    roughly translated to 404 errors on URLs to their posts.

    Props to @localheinz for bringing this regression to our notice.

    We decided to resolve this by having Jekyll ignore posts and drafts at the
    root of the site's source directory if the user customizes the
    `collection_dir` setting.

    Ergo, if you set a custom location for your collections, please ensure you
    move all of your collections into that directory. **This includes posts and
    drafts as well**. Your links generated by
    `{% raw %}{% post_url %}{% endraw %}` or `{% raw %}{% link %}{% endraw %}`
    will adapt automatically.

  * We also found out that `gem "wdm"` boosts performance while directories are
    being watched on Windows. So we recommend having it included in your Gemfile
    for a better development experience on Windows. (Newly generated Gemfiles
    will hereafter have that gem listed automatically :wink:)

In addition to the above, numerous other minor fixes and documentation updates
have been made that should improve your Jekyll experience. All of which, would
not have been possible without our wonderful contributors:

Alexandr, Andreas Möller, Ashwin Maroli, Chayoung You, Florian Thomas,
Frank Taillandier, Hendrik Schneider, Kacper Duras, Olivia, Parker Moore and
Paul Robert Lloyd.

As always, you can see our full changelog on [the History page](/docs/history/).

Happy Jekylling! :sparkles:
