/*
 * Copyright (c) 1994, 1995, 1999 Vectaport Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The copyright holders make
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 */

/* 
 * Scanner returns a stream of tokens for the ComTerp language
 */

#if !defined(_scanner_h)
#define _scanner_h

#include <ComTerp/lexscan.h>

//: C++ wrapper for ComUtil scanner capability.
class Scanner : public LexScan {
public:
    Scanner();
    Scanner(const char* path);
    Scanner(void*, char*(*)(char*,int,void*), int(*)(void*), int(*)(void*));
    // see descriptions in ComTerp or ComTerpModule.
    ~Scanner();

    const void* get_next_token(unsigned int& toktype);         
    // return pointer to token of 'toktype'.
    const char* get_next_token_string(unsigned int& toktype);
    // return pointer to string from which token was scanned.

protected:
};

#endif /* !defined(_scanner_h) */
