#include	"qpage.h"


#ifndef lint
static char	sccsid[] = "@(#)sendmail.c  1.10  06/26/97  tomiii@mtu.edu";
#endif


/*
** invoke_sendmail()
**
** This function invokes sendmail and uses a pipe to redirect stdout
** from this process to stdin of the sendmail process.
**
**	Input:
**		addr - the destination e-mail address
**
**	Returns:
**		the child process ID, or -1 on failure
*/
pid_t
invoke_sendmail(char *addr)
{
	pid_t	pid;
	int	fds[2];


	/*
	** temporary files are evil--create a pipe for sendmail instead
	*/
	if (pipe(fds) < 0) {
		qpage_log(LOG_ERR, "pipe() failed, cannot send e-mail: %s",
			strerror(errno));
		return((pid_t)-1);
	}

	switch (pid = fork()) {
		case (pid_t)-1:
			qpage_log(LOG_ERR,
				"fork() failed, cannot send e-mail: %s",
				strerror(errno));
			break;

		case 0: /* child */
			(void)dup2(fds[0], fileno(stdin));
			(void)close(fds[0]);
			(void)close(fds[1]);

			/*
			** Note that we cannot close stdout to tell
			** sendmail to send the message because there's
			** only one stdout per process.  Once we close
			** it, the game is over.  Thus, we will have to
			** avoid using the -oi flag and just write a
			** period on a line by itself to signal EOM.
			*/
			(void)execl(_PATH_SENDMAIL, "sendmail",
				"-f", "<>", addr, NULL);

			qpage_log(LOG_ERR, "exec(%s) failed: %s",
				_PATH_SENDMAIL, strerror(errno));

			_exit(-1);
			break;

		default: /* parent */
			(void)dup2(fds[1], fileno(stdout));
			(void)close(fds[0]);
			(void)close(fds[1]);
			break;
	}

	return(pid);
}


/*
** notify_administrator()
**
** This function sends e-mail notification to the qpage administrator
** whenever a page fails.
**
**	Input:
**		p - a page structure
**
**	Returns:
**		nothing
*/
void
notify_administrator(PAGE *p)
{
	rcpt_t	*rcpt;
	pid_t	pid;
	int	status;
	int	pages;
	int	still_trying;


	/*
	** Only send e-mail for failed pages.
	*/
	pages = 0;
	for (rcpt=p->rcpts; rcpt; rcpt=rcpt->next) {
		if ((rcpt->flags & (F_FAILED|F_SENTADMIN)) == F_FAILED) {
			rcpt->flags |= F_SENTADMIN;
			pages++;
		}
	}

	if (pages == 0) {
		if (Debug)
			qpage_log(LOG_DEBUG, "no failed pages for id=%s",
				p->messageid);
		return;
	}

	qpage_log(LOG_INFO, "notifying administrator of failed page id=%s",
		p->messageid);

	if ((pid = invoke_sendmail(Administrator)) == (pid_t)-1)
		return;

	printf("From: QuickPage Daemon <%s>\n", get_user());
	printf("To: QuickPage Administrator <%s>\n", Administrator);
	printf("Subject: A page has failed.\n");
	printf("\n");

	printf("The following page could not be delievered to one or more recipients:\n\n"); 

	printf("\tDate:  %s\n", my_ctime(&p->created));

	if (p->messageid)
		printf("\tMsgID: %s\n", p->messageid);

	if (p->filename)
		printf("\tFile:  %s\n", p->filename);

	if (p->from)
		printf("\tFrom:  %s\n", p->from);

	if (p->auth)
		printf("\tAuth:  %s\n", p->auth);

	if (p->ident)
		printf("\tIdent: %s\n", p->from);

	if (p->hostname)
		printf("\tHost:  %s\n", p->hostname);

	printf("\n");

	printf("\t%-30s%s\n", "Pager", "Status");
	printf("\t%-30s%s\n", "-----", "------");

	still_trying = 0;
	for (rcpt=p->rcpts; rcpt; rcpt=rcpt->next) {
		printf("\t%-30s", rcpt->pager);

		if (rcpt->flags & F_SENT) {
			printf("Delivered\n");
			continue;
		}

		if (rcpt->flags & F_FAILED) {
			printf("Failed\n");
			continue;
		}

		printf("Still trying\n");
		still_trying++;
	}

	printf("\n");

	if (still_trying == 0)
		printf("This page should be manually removed from the page queue.\n");

	/*
	** tell sendmail we're done
	*/
	printf("\n.\n");
	(void)fflush(stdout);

	/*
	** wait for sendmail to exit (do we really care?)
	*/
	while (waitpid(pid, &status, 0) < 0) {
		if (errno == EINTR)
			continue;
	}
}


/*
** notify_submitter()
**
** This function sends e-mail notification to a page submitter
** concerning the status of the page.  Mail is sent whenever the
** status changes to "sent" or "failed" for one or more recipients.
**
**	Input:
**		p - a page structure
**
**	Returns:
**		nothing
*/
void
notify_submitter(PAGE *p)
{
	rcpt_t	*rcpt;
	pid_t	pid;
	char	buff[100];
	char	*append;
	char	*address;
	char	*msg;
	int	status;
	int	pages;


	/*
	** Only send e-mail if the page was just sent or the page
	** just failed.  Also, only send e-mail about a success or
	** failure once, unless we're already sending mail because
	** of another recipient.  That is, only send e-mail if:
	**
	**	F_SENT & ~F_SENTMAIL
	** or
	**	F_FAILED & ~F_SENTMAIL
	** or
	**	one or more recipients meets the above two conditions.
	*/
	pages = 0;
	for (rcpt=p->rcpts; rcpt; rcpt=rcpt->next) {
		if ((rcpt->flags & F_SENDMAIL) == 0)
			continue;

		if ((rcpt->flags & F_SENTMAIL) == 0) {
			if (rcpt->flags & (F_SENT|F_FAILED)) {
				rcpt->flags |= F_SENTMAIL;
				pages++;
			}
		}
	}

	if (pages == 0) {
		if (Debug)
			qpage_log(LOG_DEBUG, "no e-mail to send for id=%s",
				p->messageid);
		return;
	}

	qpage_log(LOG_INFO, "sending e-mail status for id=%s", p->messageid);

	/*
	** If necessary, make sure the "from" address is qualified
	** with a hostname.  If a hostname was specified (i.e. the
	** "forcehostname" option starts with '@') then use it,
	** otherwise use the name of the machine where the page was
	** submitted from.
	*/
	if (ForceHostname) {
		if (ForceHostname[0] == '@')
			append = &ForceHostname[1];
		else
			append = p->hostname;

		if (append && strchr(p->from, '@') == NULL) {
			address = (void *)malloc(strlen(p->from) +
				strlen(append) + 2);

			(void)sprintf(address, "%s@%s", p->from, append);
		}
		else
			address = strdup(p->from);
	}
	else
		address = strdup(p->from);

	if ((pid = invoke_sendmail(address)) == (pid_t)-1)
		return;

	printf("From: QuickPage Daemon <%s>\n", get_user());
	printf("To: QuickPage User <%s>\n", address);
	printf("Subject: The status of your page\n");

	if (Administrator)
		printf("Reply-To: %s\n", Administrator);

	printf("\n");

	printf("The page you submitted has the following status:\n\n");

	printf("\tDate:    %s\n", my_ctime(&p->created));

	if (p->messageid)
		printf("\tMsgID:   %s\n", p->messageid);

	if (p->from)
		printf("\tFrom:    %s\n", p->from);

	if (p->auth)
		printf("\tAuth:    %s\n", p->auth);

	if (p->ident)
		printf("\tIdent:   %s\n", p->from);

	if (p->hostname)
		printf("\tHost:    %s\n", p->hostname);

	printf("\n");

	msg = msgcpy(buff, p->message, 50);

	printf("\tMessage: %s\n", buff);

	while (msg) {
		msg = msgcpy(buff, msg, 50);
		printf("\t         %s\n", buff);
	}

	printf("\n");

	printf("\t%-30s%s\n", "Pager", "Status");
	printf("\t%-30s%s\n", "-----", "------");

	for (rcpt=p->rcpts; rcpt; rcpt=rcpt->next) {
#ifdef ONLY_SPECIFIED_RECIPIENTS
		if ((rcpt->flags & F_SENDMAIL) == 0)
			continue;
#endif

		printf("\t%-30s", rcpt->pager);

		if (rcpt->flags & F_SENT) {
			printf("Delivered\n");
			continue;
		}

		if (rcpt->flags & F_FAILED) {
			printf("Failed\n");
			continue;
		}

		printf("Still trying\n");
	}

	printf("\n\nRegards,\nQuickPage\n");

	/*
	** tell sendmail we're done
	*/
	printf("\n.\n");
	(void)fflush(stdout);

	/*
	** wait for sendmail to exit (do we really care?)
	*/
	while (waitpid(pid, &status, 0) < 0) {
		if (errno == EINTR)
			continue;
	}

	free(address);
}
