/************************************************************************
 *	makevpopdb - Creates the vpop database for cucipop		*
 *									*
 *	Expects an input file consisting of entries looking like:	*
 *									*
 *	virtual.dom.ain/username	cleartextpassword		*
 *									*
 *	The entries must be separated by a single tab, no other		*
 *	random whitespace is allowed					*
 *									*
 *	Copyright (c) 1998, S.R. van den Berg, The Netherlands		*
 *	#include "README"						*
 ************************************************************************/
#ifdef RCS
static /*const*/char rcsid[]=
 "$Id: makevpopdb.c,v 1.5 1998/05/12 00:50:53 srb Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>

#include "sdb.h"
#include "simplecrypt.h"

#define BUFSTEP		1024

char*readtill(int c)
{ static char*buf;static size_t bufmax=0;size_t offset;
  for(offset=0;;offset++)
   { int i;
     if(offset==bufmax)
	buf=realloc(buf,bufmax+=BUFSTEP);
     if((buf[offset]=i=fgetc(stdin))==EOF||i==c)
	break;
   }
  buf[offset]='\0';
  return buf;
}

main(int argc,const char*argv[])
{ const char*dbname;int retval=EXIT_SUCCESS;DB_ENV dbenv;DB*db;
  if(argc!=2)
   { fprintf(stderr,"Usage: makedb2 dbasefile\n");
     return EX_USAGE;
   }
  dbname=argv[1];
  memset(&dbenv,0,sizeof dbenv);
  if(!db_appinit(0,0,&dbenv,0))
     fprintf(stderr,"makedb2: Can't init db subsystem\n"),retval=EX_CANTCREAT;
  else
   { if(db_open(dbname,DB_HASH,DB_CREATE|DB_TRUNCATE,0666,&dbenv,(void*)0,&db))
      { fprintf(stderr,"makedb2: Can't create %s\n",dbname);
	retval=EX_CANTCREAT;
      }
     else
      { DBT k,d;char*data;
	memset(&k,0,sizeof k);memset(&d,0,sizeof d);
	while(data=readtill('\t'),*data||!feof(stdin))
	 { char*key;size_t keylen;
	   strcpy(key=malloc((keylen=strlen(data))+1),data);
	   data=readtill('\n');k.data=key;k.size=keylen;
	   d.data=data;d.size=strlen(data);scmorph(&k,&d);
	   if(db->put(db,0,&k,&d,0))
	      break;
	 }
	db->close(db,0);
      }
     db_appexit(&dbenv);
   }
  return retval;
}
