/*
  Optimizer
  Flex file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

%{
#include <iostream.h>
#include <stdio.h>
#include "Global.h"
#include "optimizer.tab.h"

extern int linenumber;
int yyerror(char *s);
%}

%pointer

delim         [ \t]
ws            {delim}+
letter        [A-Za-z_\$\%\[\]\*#&.\\\/@\=\+\-]
digit         [0-9]
special       [:;,]
id            ({letter}|{digit})+
par           {id}*"("({id}|{special})*")"{id}*
str           "\""
string        {str}([^\n])*{str}
other         .


%%
{ws}           {/* nothing */;}
[\n]           {linenumber=linenumber+1; return _EOL;}
";"[^\n]*      {/* comment */;}

  /* Instruction : A */
"adcb"         {yylval.size = BYTE; return _ADC;}
"adcw"         {yylval.size = WORD; return _ADC;}
"adcl"         {yylval.size = LONG; return _ADC;}
"addb"         {yylval.size = BYTE; return _ADD;}
"addw"         {yylval.size = WORD; return _ADD;}
"addl"         {yylval.size = LONG; return _ADD;}
"andb"         {yylval.size = BYTE; return _AND;}
"andw"         {yylval.size = WORD; return _AND;}
"andl"         {yylval.size = LONG; return _AND;}
"arpl"         {yylval.size = NOSIZE; return _ARPL;}
"aaa"          {yylval.size = NOSIZE; return _AAA;}
"aad"          {yylval.size = NOSIZE; return _AAD;}
"aam"          {yylval.size = NOSIZE; return _AAM;}
"aas"          {yylval.size = NOSIZE; return _AAS;}

  /* Instruction : B */

"boundb"       {yylval.size = BYTE; return _BOUND;}
"boundw"       {yylval.size = WORD; return _BOUND;}
"boundl"       {yylval.size = LONG; return _BOUND;}
"bswap"	       {yylval.size = NOSIZE; return _BSWAP;}
"bsfb"         {yylval.size = BYTE; return _BSF;}
"bsfw"         {yylval.size = WORD; return _BSF;}
"bsfl"         {yylval.size = LONG; return _BSF;}
"bsrb"         {yylval.size = BYTE; return _BSR;}
"bsrw"         {yylval.size = WORD; return _BSR;}
"bsrl"         {yylval.size = LONG; return _BSR;}
"btcb"         {yylval.size = BYTE; return _BTC;}
"btcw"         {yylval.size = WORD; return _BTC;}
"btcl"         {yylval.size = LONG; return _BTC;}
"btrb"         {yylval.size = BYTE; return _BTR;}
"btrw"         {yylval.size = WORD; return _BTR;}
"btrl"         {yylval.size = LONG; return _BTR;}
"btsb"         {yylval.size = BYTE; return _BTS;}
"btsw"         {yylval.size = WORD; return _BTS;}
"btsl"         {yylval.size = LONG; return _BTS;}
"btb"	       {yylval.size = BYTE; return _BT;}
"btw"	       {yylval.size = WORD; return _BT;}
"btl"	       {yylval.size = LONG; return _BT;}

  /* Instruction : C */

"cmpxchg8b"    {yylval.size = NOSIZE; return _CMPXCHG8B;}
"cmpxchgb"     {yylval.size = BYTE; return _CMPXCHG;}
"cmpxchgw"     {yylval.size = WORD; return _CMPXCHG;}
"cmpxchgl"     {yylval.size = LONG; return _CMPXCHG;}
"cmpsb"	       {return _CMPSB;}
"cmpsl"	       {return _CMPSB;}
"cmpsd"	       {return _CMPSD;}
"cmpsw"	       {return _CMPSW;}
"cpuid"	       {yylval.size = NOSIZE; return _CPUID;}
"call"	       {yylval.size = NOSIZE; return _CALL;}
"cbtw"         {yylval.size = NOSIZE; return _CBW;}
"cltd"         {yylval.size = NOSIZE; return _CDQ;}
"clts"         {yylval.size = NOSIZE; return _CLTS;}
"cwtd"         {yylval.size = NOSIZE; return _CWD;}
"cwtl"         {yylval.size = NOSIZE; return _CWDE;}
"cmpb"         {yylval.size = BYTE; return _CMP;}
"cmpw"         {yylval.size = WORD; return _CMP;}
"cmpl"         {yylval.size = LONG; return _CMP;}
"clc"	       {yylval.size = NOSIZE; return _CLC;}
"cld"	       {yylval.size = NOSIZE; return _CLD;}
"cli"	       {yylval.size = NOSIZE; return _CLI;}
"cmc"	       {yylval.size = NOSIZE; return _CMC;}

"cmovnae"      {yylval.size = NOSIZE; return _CMOVNAE;}
"cmovnbe"      {yylval.size = NOSIZE; return _CMOVNBE;}
"cmovnge"      {yylval.size = NOSIZE; return _CMOVNGE;}
"cmovnle"      {yylval.size = NOSIZE; return _CMOVNLE;}
"cmovno"       {yylval.size = NOSIZE; return _CMOVNO;}
"cmovnc"       {yylval.size = NOSIZE; return _CMOVNC;}
"cmovae"       {yylval.size = NOSIZE; return _CMOVAE;}
"cmovnb"       {yylval.size = NOSIZE; return _CMOVNB;}
"cmovne"       {yylval.size = NOSIZE; return _CMOVNE;}
"cmovnz"       {yylval.size = NOSIZE; return _CMOVNZ;}
"cmovbe"       {yylval.size = NOSIZE; return _CMOVBE;}
"cmovna"       {yylval.size = NOSIZE; return _CMOVNA;}
"cmovns"       {yylval.size = NOSIZE; return _CMOVNS;}
"cmovpe"       {yylval.size = NOSIZE; return _CMOVPE;}
"cmovnp"       {yylval.size = NOSIZE; return _CMOVNP;}
"cmovpo"       {yylval.size = NOSIZE; return _CMOVPO;}
"cmovge"       {yylval.size = NOSIZE; return _CMOVGE;}
"cmovnl"       {yylval.size = NOSIZE; return _CMOVNL;}
"cmovle"       {yylval.size = NOSIZE; return _CMOVLE;}
"cmovng"       {yylval.size = NOSIZE; return _CMOVNG;}
"cmovo"	       {yylval.size = NOSIZE; return _CMOVO;}
"cmovc"	       {yylval.size = NOSIZE; return _CMOVC;}
"cmovb"	       {yylval.size = NOSIZE; return _CMOVB;}
"cmove"	       {yylval.size = NOSIZE; return _CMOVE;}
"cmovz"	       {yylval.size = NOSIZE; return _CMOVZ;}
"cmova"        {yylval.size = NOSIZE; return _CMOVA;}
"cmovs"	       {yylval.size = NOSIZE; return _CMOVS;}
"cmovp"        {yylval.size = NOSIZE; return _CMOVP;}
"cmovl"	       {yylval.size = NOSIZE; return _CMOVL;}
"cmovg"	       {yylval.size = NOSIZE; return _CMOVG;}

  /* Instruction : D */
 
"decb"         {yylval.size = BYTE; return _DEC;}
"decw"         {yylval.size = WORD; return _DEC;}
"decl"         {yylval.size = LONG; return _DEC;}
"divb"         {yylval.size = BYTE; return _DIV;}
"divw"         {yylval.size = WORD; return _DIV;}
"divl"         {yylval.size = LONG; return _DIV;}
"daa"	       {yylval.size = NOSIZE; return _DAA;}
"das"	       {yylval.size = NOSIZE; return _DAS;}

  /* Instruction : E */

"enter"	       {yylval.size = NOSIZE; return _ENTER;}
"emms"	       {yylval.size = NOSIZE; return _EMMS;}
"esc"	       {yylval.size = NOSIZE; return _ESC;}

  /* Instruction : F */
"fcmovnbe"	{yylval.size = NOSIZE; return _FCMOVNBE;}
"fcmovbe"	{yylval.size = NOSIZE; return _FCMOVBE;}
"fcmovnb"	{yylval.size = NOSIZE; return _FCMOVNB;}
"fcmovne"	{yylval.size = NOSIZE; return _FCMOVNE;}
"fcmovnu"	{yylval.size = NOSIZE; return _FCMOVNU;}
"fdecstp"	{yylval.size = NOSIZE; return _FDECSTP;}  
"ficompl"	{yylval.size = LONG;   return _FICOMP;} 
"ficomps"	{yylval.size = SHORT;  return _FICOMP;} 
"fidivrl"	{yylval.size = LONG;   return _FIDIVR;} 
"fidivrs"	{yylval.size = SHORT;  return _FIDIVR;} 
"fincstp"	{yylval.size = NOSIZE; return _FINCSTP;}  
"fistpll"	{yylval.size = QUAD;   return _FISTP;} 
"fisubrl"	{yylval.size = LONG;   return _FISUBR;} 
"fisubrs"	{yylval.size = SHORT;  return _FISUBR;} 
"fnstenv"	{yylval.size = NOSIZE; return _FNSTENV;}
"frndint"	{yylval.size = NOSIZE; return _FRNDINT;} 
"fsincos"	{yylval.size = NOSIZE; return _FSINCOS;} 
"fucomip"	{yylval.size = NOSIZE; return _FUCOMIP;}
"fucompp"	{yylval.size = NOSIZE; return _FUCOMPP;}
"fxtract"	{yylval.size = NOSIZE; return _FXTRACT;} 
"fyl2xp1"	{yylval.size = NOSIZE; return _FYL2XP1;} 
"fcmovb"	{yylval.size = NOSIZE; return _FCMOVB;}
"fcmove"	{yylval.size = NOSIZE; return _FCMOVE;}
"fcmovu"	{yylval.size = NOSIZE; return _FCMOVU;}
"fcomip"	{yylval.size = NOSIZE; return _FCOMIP;}
"fcompl"	{yylval.size = LONG;   return _FCOMP;}  
"fcompp"	{yylval.size = NOSIZE; return _FCOMPP;} 
"fcomps"	{yylval.size = SHORT;  return _FCOMP;}  
"fdivrl"	{yylval.size = LONG;   return _FDIVR;}  
"fdivrp"	{yylval.size = NOSIZE; return _FDIVRP;} 
"fdivrs"	{yylval.size = SHORT;  return _FDIVR;}  
"ffreep"	{yylval.size = NOSIZE; return _FFREEP;}  // Not supported
"fiaddl"	{yylval.size = LONG;   return _FIADD;} 
"fiadds"	{yylval.size = SHORT;  return _FIADD;} 
"ficoml"	{yylval.size = LONG;   return _FICOM;} 
"ficoms"	{yylval.size = SHORT;  return _FICOM;} 
"fidivl"	{yylval.size = LONG;   return _FIDIV;} 
"fidivs"	{yylval.size = SHORT;  return _FIDIV;} 
"fildll"	{yylval.size = QUAD;   return _FILD;} 
"fimull"	{yylval.size = LONG;   return _FIMUL;} 
"fimuls"	{yylval.size = SHORT;  return _FIMUL;} 
"fistpl"	{yylval.size = LONG;   return _FISTP;} 
"fistpq"	{yylval.size = QUAD;   return _FISTP;} 
"fisubl"	{yylval.size = LONG;   return _FISUB;} 
"fisubs"	{yylval.size = SHORT;  return _FISUB;} 
"fldenv"	{yylval.size = NOSIZE; return _FLDENV;} 
"fldl2e"	{yylval.size = NOSIZE; return _FLDL2E;}
"fldl2t"	{yylval.size = NOSIZE; return _FLDL2T;}
"fldlg2"	{yylval.size = NOSIZE; return _FLDLG2;}
"fldln2"	{yylval.size = NOSIZE; return _FLDLN2;}
"fnclex"	{yylval.size = NOSIZE; return _FNCLEX;} 
"fninit"	{yylval.size = NOSIZE; return _FNINIT;} 
"fnsave"	{yylval.size = NOSIZE; return _FNSAVE;} 
"fnstcw"	{yylval.size = NOSIZE; return _FNSTCW;} 
"fnstsw"	{yylval.size = NOSIZE; return _FNSTSW;} 
"fpatan"	{yylval.size = NOSIZE; return _FPATAN;} 
"fprem1"	{yylval.size = NOSIZE; return _FPREM1;}  
"frstor"	{yylval.size = NOSIZE; return _FRSTOR;} 
"fscale"	{yylval.size = NOSIZE; return _FSCALE;}  
"fstenv"	{yylval.size = NOSIZE; return _FSTENV;} 
"fsubrl"	{yylval.size = LONG;   return _FSUBR;}  
"fsubrp"	{yylval.size = NOSIZE; return _FSUBRP;} 
"fsubrs"	{yylval.size = SHORT;  return _FSUBR;}  
"fucomi"	{yylval.size = NOSIZE; return _FUCOMI;}
"fucomp"	{yylval.size = NOSIZE; return _FUCOMP;} 
"f2xm1"		{yylval.size = NOSIZE; return _F2XM1;}	
"faddl"		{yylval.size = LONG;   return _FADD;}  
"faddp"		{yylval.size = NOSIZE; return _FADDP;} 
"fadds"		{yylval.size = SHORT;  return _FADD;}  
"fbstp"		{yylval.size = NOSIZE; return _FBSTP;} 
"fclex"		{yylval.size = NOSIZE; return _FCLEX;}  
"fcomi"		{yylval.size = NOSIZE; return _FCOMI;}
"fcoml"		{yylval.size = LONG;   return _FCOM;}  
"fcomp"		{yylval.size = NOSIZE; return _FCOMP;}  
"fcoms"		{yylval.size = SHORT;  return _FCOM;}  
"fdivl"		{yylval.size = LONG;   return _FDIV;}  
"fdivp"		{yylval.size = NOSIZE; return _FDIVP;} 
"fdivr"		{yylval.size = NOSIZE; return _FDIVR;}  
"fdivs"		{yylval.size = SHORT;  return _FDIV;}  
"ffree"		{yylval.size = NOSIZE; return _FFREE;}  
"fildl"		{yylval.size = LONG;   return _FILD;} 
"fildq"		{yylval.size = QUAD;   return _FILD;} 
"finit"		{yylval.size = NOSIZE; return _FINIT;}  
"fistl"		{yylval.size = LONG;   return _FIST;} 
"fistp"		{yylval.size = NOSIZE; return _FISTP;} 
"fldcw"		{yylval.size = NOSIZE; return _FLDCW;}  
"fldpi"		{yylval.size = NOSIZE; return _FLDPI;} 
"fmull"		{yylval.size = LONG;   return _FMUL;}  
"fmulp"		{yylval.size = NOSIZE; return _FMULP;} 
"fmuls"		{yylval.size = SHORT;  return _FMUL;}  
"fprem"		{yylval.size = NOSIZE; return _FPREM;}  
"fptan"		{yylval.size = NOSIZE; return _FPTAN;}  
"fsave"		{yylval.size = NOSIZE; return _FSAVE;}  
"fsqrt"		{yylval.size = NOSIZE; return _FSQRT;}   
"fstcw"		{yylval.size = NOSIZE; return _FSTCW;}  
"fstpl"		{yylval.size = LONG;   return _FSTP;}  
"fstps"		{yylval.size = SHORT;  return _FSTP;}  
"fstpt"		{yylval.size = TERA;   return _FSTP;}  
"fstsw"		{yylval.size = NOSIZE; return _FSTSW;}  
"fsubl"		{yylval.size = LONG;   return _FSUB;}  
"fsubp"		{yylval.size = NOSIZE; return _FSUBP;} 
"fsubr"		{yylval.size = NOSIZE; return _FSUBR;}  
"fsubs"		{yylval.size = SHORT;  return _FSUB;}  
"fucom"		{yylval.size = NOSIZE; return _FUCOM;}  
"fwait"		{yylval.size = NOSIZE; return _FWAIT;}  
"fyl2x"		{yylval.size = NOSIZE; return _FYL2X;}  
"fabs"		{yylval.size = NOSIZE; return _FABS;}  
"fadd"		{yylval.size = NOSIZE; return _FADD;}  
"fbld"		{yylval.size = NOSIZE; return _FBLD;} 
"fchs"		{yylval.size = NOSIZE; return _FCHS;}
"fcom"		{yylval.size = NOSIZE; return _FCOM;}  
"fcos"		{yylval.size = NOSIZE; return _FCOS;}  
"fdiv"		{yylval.size = NOSIZE; return _FDIV;}  
"fild"		{yylval.size = NOSIZE; return _FILD;} 
"fist"		{yylval.size = NOSIZE; return _FIST;} 
"fld1"		{yylval.size = NOSIZE; return _FLD1;}  
"fldl"		{yylval.size = LONG;   return _FLD;}  
"flds"		{yylval.size = SHORT;  return _FLD;}  
"fldt"		{yylval.size = TERA;   return _FLD;}    
"fldz"		{yylval.size = NOSIZE; return _FLDZ;}  
"fmul"		{yylval.size = NOSIZE; return _FMUL;}  
"fnop"		{yylval.size = NOSIZE; return _FNOP;}   
"fsin"		{yylval.size = NOSIZE; return _FSIN;}  
"fstl"		{yylval.size = LONG;   return _FST;}  
"fstp"		{yylval.size = NOSIZE; return _FSTP;}  
"fsts"		{yylval.size = SHORT;  return _FST;}  
"fsub"		{yylval.size = NOSIZE; return _FSUB;}  
"ftst"		{yylval.size = NOSIZE; return _FTST;}  
"fxam"		{yylval.size = NOSIZE; return _FXAM;}  
"fxch"		{yylval.size = NOSIZE; return _FXCH;}  
"fld"		{yylval.size = NOSIZE; return _FLD;}  
"fst"		{yylval.size = NOSIZE; return _FST;}  


  /* Instruction : H */

"hlt"	       {yylval.size = NOSIZE; return _HLT;}

  /* Instruction : I */

"invlpg"       {yylval.size = NOSIZE; return _INVLPG;}
"idivb"        {yylval.size = BYTE; return _IDIV;}
"idivw"        {yylval.size = WORD; return _IDIV;}
"idivl"        {yylval.size = LONG; return _IDIV;}
"imulb"        {yylval.size = BYTE; return _IMUL;}
"imulw"        {yylval.size = WORD; return _IMUL;}
"imull"        {yylval.size = LONG; return _IMUL;}
"iretd"	       {yylval.size = NOSIZE; return _IRETD;}
"incb"         {yylval.size = BYTE; return _INC;}
"incw"         {yylval.size = WORD; return _INC;}
"incl"         {yylval.size = LONG; return _INC;}
"insb"	       {return _INSB;}
"insl"	       {return _INSB;}
"insd"	       {return _INSD;}
"insw"	       {return _INSW;}
"int3"	       {yylval.size = NOSIZE; return _INT3;}
"into"	       {yylval.size = NOSIZE; return _INTO;}
"invd"	       {yylval.size = NOSIZE; return _INVD;}
"iret"	       {yylval.size = NOSIZE; return _IRET;}
"inb"          {yylval.size = BYTE; return _IN;}
"inw"          {yylval.size = WORD; return _IN;}
"inl"          {yylval.size = LONG; return _IN;}
"int"	       {yylval.size = NOSIZE; return _INT;}


  /* Instruction : J */

"jecxz"	       {yylval.size = NOSIZE; return _JECXZ;}
"jcxz"	       {yylval.size = NOSIZE; return _JCXZ;}
"jmp"	       {yylval.size = NOSIZE; return _JMP;}

"jnae"	       {yylval.size = NOSIZE; return _JNAE;}
"jnbe"	       {yylval.size = NOSIZE; return _JNBE;}
"jnge"	       {yylval.size = NOSIZE; return _JNGE;}
"jnle"	       {yylval.size = NOSIZE; return _JNLE;}
"jno"	       {yylval.size = NOSIZE; return _JNO;}
"jnc"	       {yylval.size = NOSIZE; return _JNC;}
"jae"	       {yylval.size = NOSIZE; return _JAE;}
"jnb"	       {yylval.size = NOSIZE; return _JNB;}
"jne"	       {yylval.size = NOSIZE; return _JNE;}
"jnz"	       {yylval.size = NOSIZE; return _JNZ;}
"jbe"	       {yylval.size = NOSIZE; return _JBE;}
"jna"	       {yylval.size = NOSIZE; return _JNA;}
"jns"	       {yylval.size = NOSIZE; return _JNS;}
"jpe"	       {yylval.size = NOSIZE; return _JPE;}
"jnp"	       {yylval.size = NOSIZE; return _JNP;}
"jpo"	       {yylval.size = NOSIZE; return _JPO;}
"jge"	       {yylval.size = NOSIZE; return _JGE;}
"jnl"	       {yylval.size = NOSIZE; return _JNL;}
"jle"	       {yylval.size = NOSIZE; return _JLE;}
"jng"	       {yylval.size = NOSIZE; return _JNG;}
"jo"	       {yylval.size = NOSIZE; return _JO;}
"jc"	       {yylval.size = NOSIZE; return _JC;}
"jb"	       {yylval.size = NOSIZE; return _JB;}
"je"	       {yylval.size = NOSIZE; return _JE;}
"jz"	       {yylval.size = NOSIZE; return _JZ;}
"ja"	       {yylval.size = NOSIZE; return _JA;}
"js"	       {yylval.size = NOSIZE; return _JS;}
"jp"	       {yylval.size = NOSIZE; return _JP;}
"jl"	       {yylval.size = NOSIZE; return _JL;}
"jg"	       {yylval.size = NOSIZE; return _JG;}


  /* Instruction : L */

"loopne"       {yylval.size = NOSIZE; return _LOOPNE;}
"loopnz"       {yylval.size = NOSIZE; return _LOOPNZ;}
"lcall"        {yylval.size = NOSIZE; return _CALL;}
"leave"	       {yylval.size = NOSIZE; return _LEAVE;}
"lodsb"        {return _LODSB;}
"lodsl"        {return _LODSB;}
"lodsd"	       {return _LODSD;}
"lodsw"	       {return _LODSW;}
"loope"	       {yylval.size = NOSIZE; return _LOOPE;}
"loopz"	       {yylval.size = NOSIZE; return _LOOPZ;}
"lahf"	       {yylval.size = NOSIZE; return _LAHF;}
"larb"         {yylval.size = BYTE; return _LAR;}
"larw"         {yylval.size = WORD; return _LAR;}
"larl"         {yylval.size = LONG; return _LAR;}
"ldsb"         {yylval.size = BYTE; return _LDS;}
"ldsw"         {yylval.size = WORD; return _LDS;}
"ldsl"         {yylval.size = LONG; return _LDS;}
"leab"         {yylval.size = BYTE; return _LEA;}
"leaw"         {yylval.size = WORD; return _LEA;}
"leal"         {yylval.size = LONG; return _LEA;}
"lesb"         {yylval.size = BYTE; return _LES;}
"lesw"         {yylval.size = WORD; return _LES;}
"lesl"         {yylval.size = LONG; return _LES;}
"lfsb"         {yylval.size = BYTE; return _LFS;}
"lfsw"         {yylval.size = WORD; return _LFS;}
"lfsl"         {yylval.size = LONG; return _LFS;}
"lgdt"	       {yylval.size = NOSIZE; return _LGDT;}
"lgsb"         {yylval.size = BYTE; return _LGS;}
"lgsw"         {yylval.size = WORD; return _LGS;}
"lgsl"         {yylval.size = LONG; return _LGS;}
"lidt"	       {yylval.size = NOSIZE; return _LIDT;}
"ljmp"         {yylval.size = NOSIZE; return _JMP;}
"lldt"	       {yylval.size = NOSIZE; return _LLDT;}
"lmsw"	       {yylval.size = NOSIZE; return _LMSW;}
"lock"         {yylval.size = NOSIZE; return _LOCK;}
"loop"	       {yylval.size = NOSIZE; return _LOOP;}
"lret"         {yylval.size = NOSIZE; return _RETF;}
"lslb"         {yylval.size = BYTE; return _LSL;}
"lslw"         {yylval.size = WORD; return _LSL;}
"lsll"         {yylval.size = LONG; return _LSL;}
"lssb"         {yylval.size = BYTE; return _LSS;}
"lssw"         {yylval.size = WORD; return _LSS;}
"lssl"         {yylval.size = LONG; return _LSS;}
"ltr"	       {yylval.size = NOSIZE; return _LTR;}

  /* Instruction : M */

"movsbl"       {yylval.size = NOSIZE; return _MOVSX_B;}
"movsbw"       {yylval.size = NOSIZE; return _MOVSX_B;}
"movswl"       {yylval.size = NOSIZE; return _MOVSX_W;}  
"movzbl"       {yylval.size = NOSIZE; return _MOVZX_B;}
"movzbw"       {yylval.size = NOSIZE; return _MOVZX_B;}
"movzwl"       {yylval.size = NOSIZE; return _MOVZX_W;}  
"movsb"        {yylval.size = BYTE; return _MOVS;}
"movsw"        {yylval.size = WORD; return _MOVS;}
"movsl"        {yylval.size = LONG; return _MOVS;}
"movb"         {yylval.size = BYTE; return _MOV;}
"movw"         {yylval.size = WORD; return _MOV;}
"movl"         {yylval.size = LONG; return _MOV;}
"movd"	       {return _MOVD;}  // ?
"movq"	       {return _MOVQ;}  // ?
"mulb"         {yylval.size = BYTE; return _MUL;}
"mulw"         {yylval.size = WORD; return _MUL;}
"mull"         {yylval.size = LONG; return _MUL;}


  /* Instruction : N */

"negb"         {yylval.size = BYTE; return _NEG;}
"negw"         {yylval.size = WORD; return _NEG;}
"negl"         {yylval.size = LONG; return _NEG;}
"notb"         {yylval.size = BYTE; return _NOT;}
"notw"         {yylval.size = WORD; return _NOT;}
"notl"         {yylval.size = LONG; return _NOT;}
"nop"	       {yylval.size = NOSIZE; return _NOP;}


  /* Instruction : O */

"outsb"	       {return _OUTSB;}
"outsl"	       {return _OUTSB;}
"outsd"	       {return _OUTSD;}
"outsw"	       {return _OUTSW;}
"outb"         {yylval.size = BYTE; return _OUT;}
"outw"         {yylval.size = WORD; return _OUT;}
"outl"         {yylval.size = LONG; return _OUT;}
"orb"          {yylval.size = BYTE; return _OR;}
"orw"          {yylval.size = WORD; return _OR;}
"orl"          {yylval.size = LONG; return _OR;}

  /* Instruction : P */

"punpckhbw"    {yylval.size = NOSIZE; return _PUNPCKHBW;}
"punpckhdq"    {yylval.size = NOSIZE; return _PUNPCKHDQ;}
"punpckhwd"    {yylval.size = NOSIZE; return _PUNPCKHWD;}
"punpcklbw"    {yylval.size = NOSIZE; return _PUNPCKLBW;}
"punpckldq"    {yylval.size = NOSIZE; return _PUNPCKLDQ;}
"punpcklwd"    {yylval.size = NOSIZE; return _PUNPCKLWD;}
"packssdw"     {yylval.size = NOSIZE; return _PACKSSDW;}
"packsswb"     {yylval.size = NOSIZE; return _PACKSSWB;}
"packuswb"     {yylval.size = NOSIZE; return _PACKUSWB;}
"paddusb"      {yylval.size = NOSIZE; return _PADDUSB;}
"paddusw"      {yylval.size = NOSIZE; return _PADDUSW;}
"pcmpeqb"      {yylval.size = NOSIZE; return _PCMPEQB;}
"pcmpeqd"      {yylval.size = NOSIZE; return _PCMPEQD;}
"pcmpeqw"      {yylval.size = NOSIZE; return _PCMPEQW;}
"pcmpgtb"      {yylval.size = NOSIZE; return _PCMPGTB;}
"pcmpgtd"      {yylval.size = NOSIZE; return _PCMPGTD;}
"pcmpgtw"      {yylval.size = NOSIZE; return _PCMPGTW;}
"pmaddwd"      {yylval.size = NOSIZE; return _PMADDWD;}
"psubusb"      {yylval.size = NOSIZE; return _PSUBUSB;}
"psubusw"      {yylval.size = NOSIZE; return _PSUBUSW;}
"paddsb"       {yylval.size = NOSIZE; return _PADDSB;}
"paddsw"       {yylval.size = NOSIZE; return _PADDSW;}
"pmulhw"       {yylval.size = NOSIZE; return _PMULHW;}
"pmullw"       {yylval.size = NOSIZE; return _PMULLW;}
"pshimd"       {yylval.size = NOSIZE; return _PSHIMD;}
"pshimq"       {yylval.size = NOSIZE; return _PSHIMQ;}
"pshimw"       {yylval.size = NOSIZE; return _PSHIMW;}
"psubsb"       {yylval.size = NOSIZE; return _PSUBSB;}
"psubsw"       {yylval.size = NOSIZE; return _PSUBSW;}
"pushad"       {yylval.size = NOSIZE; return _PUSHAD;}
"pushfd"       {yylval.size = NOSIZE; return _PUSHFD;}
"pslld"	       {yylval.size = NOSIZE; return _PSLLD;}
"psllq"	       {yylval.size = NOSIZE; return _PSLLQ;}
"psllw"	       {yylval.size = NOSIZE; return _PSLLW;}
"psrad"	       {yylval.size = NOSIZE; return _PSRAD;}
"psraw"	       {yylval.size = NOSIZE; return _PSRAW;}
"psrld"	       {yylval.size = NOSIZE; return _PSRLD;}
"psrlq"	       {yylval.size = NOSIZE; return _PSRLQ;}
"psrlw"	       {yylval.size = NOSIZE; return _PSRLW;}
"psubb"	       {yylval.size = NOSIZE; return _PSUBB;}
"psubd"	       {yylval.size = NOSIZE; return _PSUBD;}
"paddb"	       {yylval.size = NOSIZE; return _PADDB;}
"paddd"	       {yylval.size = NOSIZE; return _PADDD;}
"paddw"	       {yylval.size = NOSIZE; return _PADDW;}
"pandn"	       {yylval.size = NOSIZE; return _PANDN;}
"popad"	       {yylval.size = NOSIZE; return _POPAD;}
"popfd"	       {yylval.size = NOSIZE; return _POPFD;}
"psubw"	       {yylval.size = NOSIZE; return _PSUBW;}
"pushb"        {yylval.size = BYTE; return _PUSH; }
"pushw"        {yylval.size = WORD; return _PUSH; }
"pushl"        {yylval.size = LONG; return _PUSH; }
"pusha"	       {yylval.size = NOSIZE; return _PUSHA;}
"pushf"	       {yylval.size = NOSIZE; return _PUSHF;}
"pand"	       {yylval.size = NOSIZE; return _PAND;}
"popb"         {yylval.size = BYTE; return _POP; }
"popw"         {yylval.size = WORD; return _POP; }
"popl"         {yylval.size = LONG; return _POP; }
"popa"	       {yylval.size = NOSIZE; return _POPA;}
"popf"	       {yylval.size = NOSIZE; return _POPF;}
"pxor"	       {yylval.size = NOSIZE; return _PXOR;}
"por"	       {yylval.size = NOSIZE; return _POR;}


  /* Instruction : R */

"rdmsr"	       {yylval.size = NOSIZE; return _RDMSR;}
"rdpmc"	       {yylval.size = NOSIZE; return _RDPMC;}
"rdtsc"	       {yylval.size = NOSIZE; return _RDTSC;}
"repne"	       {yylval.size = NOSIZE; return _REPNE;}
"repnz"        {yylval.size = NOSIZE; return _REPNZ;}
"rclb"         {yylval.size = BYTE; return _RCL; }
"rclw"         {yylval.size = WORD; return _RCL; }
"rcll"         {yylval.size = LONG; return _RCL; }
"rcrb"         {yylval.size = BYTE; return _RCR; }
"rcrw"         {yylval.size = WORD; return _RCR; }
"rcrl"         {yylval.size = LONG; return _RCR; }
"repe"	       {yylval.size = NOSIZE; return _REPE;}
"repz"         {yylval.size = NOSIZE; return _REPZ;}
"retf"	       {yylval.size = NOSIZE; return _RETF;}
"retn"	       {yylval.size = NOSIZE; return _RETN;}
"rolb"         {yylval.size = BYTE; return _ROL; }
"rolw"         {yylval.size = WORD; return _ROL; }
"roll"         {yylval.size = LONG; return _ROL; }
"rorb"         {yylval.size = BYTE; return _ROR; }
"rorw"         {yylval.size = WORD; return _ROR; }
"rorl"         {yylval.size = LONG; return _ROR; }
"rep"	       {yylval.size = NOSIZE; return _REP;}
"ret"	       {yylval.size = NOSIZE; return _RET;}
"rsm"	       {yylval.size = NOSIZE; return _RSM;}

  /* Instruction : S */

"scasb"	       {return _SCASB;}
"scasl"	       {return _SCASB;}
"scasd"	       {return _SCASD;}
"scasw"	       {return _SCASW;}
"shldb"        {yylval.size = BYTE; return _SHLD; }
"shldw"        {yylval.size = WORD; return _SHLD; }
"shldl"        {yylval.size = LONG; return _SHLD; }
"shrdb"        {yylval.size = BYTE; return _SHRD; }
"shrdw"        {yylval.size = WORD; return _SHRD; }
"shrdl"        {yylval.size = LONG; return _SHRD; }
"stosb"	       {return _STOSB;}
"stosl"	       {return _STOSB;}
"stosd"	       {return _STOSD;}
"stosw"	       {return _STOSW;}
"sahf"	       {yylval.size = NOSIZE; return _SAHF;}
"salb"         {yylval.size = BYTE; return _SAL; }
"salw"         {yylval.size = WORD; return _SAL; }
"sall"         {yylval.size = LONG; return _SAL; }
"salc"	       {yylval.size = NOSIZE; return _SALC;}
"sarb"         {yylval.size = BYTE; return _SAR; }
"sarw"         {yylval.size = WORD; return _SAR; }
"sarl"         {yylval.size = LONG; return _SAR; }
"sbbb"         {yylval.size = BYTE; return _SBB; }
"sbbw"         {yylval.size = WORD; return _SBB; }
"sbbl"         {yylval.size = LONG; return _SBB; }
"sgdt"	       {yylval.size = NOSIZE; return _SGDT;}
"shlb"         {yylval.size = BYTE; return _SHL; }
"shlw"         {yylval.size = WORD; return _SHL; }
"shll"         {yylval.size = LONG; return _SHL; }
"shrb"         {yylval.size = BYTE; return _SHR; }
"shrw"         {yylval.size = WORD; return _SHR; }
"shrl"         {yylval.size = LONG; return _SHR; }
"sidt"	       {yylval.size = NOSIZE; return _SIDT;}
"sldt"	       {yylval.size = NOSIZE; return _SLDT;}
"smsw"	       {yylval.size = NOSIZE; return _SMSW;}
"subb"         {yylval.size = BYTE; return _SUB; }
"subw"         {yylval.size = WORD; return _SUB; }
"subl"         {yylval.size = LONG; return _SUB; }
"smi"	       {yylval.size = NOSIZE; return _SMI;}
"stc"	       {yylval.size = NOSIZE; return _STC;}
"std"	       {yylval.size = NOSIZE; return _STD;}
"sti"	       {yylval.size = NOSIZE; return _STI;}
"str"	       {yylval.size = NOSIZE; return _STR;}

"setnae"       {yylval.size = NOSIZE; return _SETNAE;} 
"setnbe"       {yylval.size = NOSIZE; return _SETNBE;} 
"setnge"       {yylval.size = NOSIZE; return _SETNGE;} 
"setnle"       {yylval.size = NOSIZE; return _SETNLE;} 
"setno"	       {yylval.size = NOSIZE; return _SETNO;}  
"setae"	       {yylval.size = NOSIZE; return _SETAE;}  
"setnb"	       {yylval.size = NOSIZE; return _SETNB;}  
"setne"	       {yylval.size = NOSIZE; return _SETNE;}  
"setnz"        {yylval.size = NOSIZE; return _SETNZ;}  
"setbe"	       {yylval.size = NOSIZE; return _SETBE;}  
"setna"	       {yylval.size = NOSIZE; return _SETNA;}  
"setns"	       {yylval.size = NOSIZE; return _SETNS;}  
"setpe"        {yylval.size = NOSIZE; return _SETPE;}  
"setnp"	       {yylval.size = NOSIZE; return _SETNP;}  
"setpo"	       {yylval.size = NOSIZE; return _SETPO;}  
"setge"	       {yylval.size = NOSIZE; return _SETGE;}  
"setnl"	       {yylval.size = NOSIZE; return _SETNL;}  
"setle"	       {yylval.size = NOSIZE; return _SETLE;}  
"setng"	       {yylval.size = NOSIZE; return _SETNG;}  
"seto"	       {yylval.size = NOSIZE; return _SETO;}  
"setb"	       {yylval.size = NOSIZE; return _SETB;}    
"sete"	       {yylval.size = NOSIZE; return _SETE;}   
"setz"	       {yylval.size = NOSIZE; return _SETZ;}   
"seta"	       {yylval.size = NOSIZE; return _SETA;}   
"sets"	       {yylval.size = NOSIZE; return _SETS;}   
"setp"	       {yylval.size = NOSIZE; return _SETP;}   
"setl"	       {yylval.size = NOSIZE; return _SETL;}   
"setg"	       {yylval.size = NOSIZE; return _SETG;}   

  /* Instruction : T */

"testb"        {yylval.size = BYTE; return _TEST; }
"testw"        {yylval.size = WORD; return _TEST; }
"testl"        {yylval.size = LONG; return _TEST; }

  /* Instruction : W */

"wbinvd"       {yylval.size = NOSIZE; return _WBINVD;}
"wrmsr"	       {yylval.size = NOSIZE; return _WRMSR;}
"wait"	       {yylval.size = NOSIZE; return _WAIT;}

  /* Instruction : V */

"verr"	       {yylval.size = NOSIZE; return _VERR;}
"verw"	       {yylval.size = NOSIZE; return _VERW;}

  /* Instruction : X */
 
"xaddb"        {yylval.size = BYTE; return _XADD; }
"xaddw"        {yylval.size = WORD; return _XADD; }
"xaddl"        {yylval.size = LONG; return _XADD; }
"xchgb"        {yylval.size = BYTE; return _XCHG; }
"xchgw"        {yylval.size = WORD; return _XCHG; }
"xchgl"        {yylval.size = LONG; return _XCHG; }
"xlat"	       {yylval.size = NOSIZE; return _XLAT;}
"xorb"         {yylval.size = BYTE; return _XOR; }
"xorw"         {yylval.size = WORD; return _XOR; }
"xorl"         {yylval.size = LONG; return _XOR; }

   
  /* Reserved words */

".version"         {strcpy(yylval.label,yytext); return _RESERVED;}
"gcc2_compiled.:"  {strcpy(yylval.label,yytext); return _RESERVED;}

".abort"        {strcpy(yylval.label,yytext); return _RESERVED;}
".align"        {strcpy(yylval.label,yytext); return _RESERVED;}
".app-file"     {strcpy(yylval.label,yytext); return _RESERVED;}
".ascii"        {strcpy(yylval.label,yytext); return _RESERVED;}
".asciz"        {strcpy(yylval.label,yytext); return _RESERVED;}
".balign"       {strcpy(yylval.label,yytext); return _RESERVED;}
".byte"         {strcpy(yylval.label,yytext); return _RESERVED;}
".comm"         {strcpy(yylval.label,yytext); return _RESERVED;}
".data"         {strcpy(yylval.label,yytext); return _RESERVED;}
".def"          {strcpy(yylval.label,yytext); return _RESERVED;}
".desc"         {strcpy(yylval.label,yytext); return _RESERVED;}
".dim"          {strcpy(yylval.label,yytext); return _RESERVED;}
".double"       {strcpy(yylval.label,yytext); return _RESERVED;}
".eject"        {strcpy(yylval.label,yytext); return _RESERVED;}
".else"         {strcpy(yylval.label,yytext); return _RESERVED;}
".endef"        {strcpy(yylval.label,yytext); return _RESERVED;}
".endif"        {strcpy(yylval.label,yytext); return _RESERVED;}
".equ"          {strcpy(yylval.label,yytext); return _RESERVED;}
".equiv"        {strcpy(yylval.label,yytext); return _RESERVED;}
".err"          {strcpy(yylval.label,yytext); return _RESERVED;}
".extern"       {strcpy(yylval.label,yytext); return _RESERVED;}
".file"         {strcpy(yylval.label,yytext); return _RESERVED;}
".fill"         {strcpy(yylval.label,yytext); return _RESERVED;}
".global"       {strcpy(yylval.label,yytext); return _RESERVED;}
".globl"        {strcpy(yylval.label,yytext); return _RESERVED;}
".hword"        {strcpy(yylval.label,yytext); return _RESERVED;}
".ident"        {strcpy(yylval.label,yytext); return _RESERVED;}
".if"           {strcpy(yylval.label,yytext); return _RESERVED;}
".include"      {strcpy(yylval.label,yytext); return _RESERVED;}
".int"          {strcpy(yylval.label,yytext); return _RESERVED;}
".irp"          {strcpy(yylval.label,yytext); return _RESERVED;}
".irpc"         {strcpy(yylval.label,yytext); return _RESERVED;}
".lcomm"        {strcpy(yylval.label,yytext); return _RESERVED;}
".lflags"       {strcpy(yylval.label,yytext); return _RESERVED;}
".line"         {strcpy(yylval.label,yytext); return _RESERVED;}
".ln"           {strcpy(yylval.label,yytext); return _RESERVED;}
".linkonce"     {strcpy(yylval.label,yytext); return _RESERVED;}
".list"         {strcpy(yylval.label,yytext); return _RESERVED;}
".long"         {strcpy(yylval.label,yytext); return _RESERVED;}
".local"        {strcpy(yylval.label,yytext); return _RESERVED;}
".macro"        {strcpy(yylval.label,yytext); return _RESERVED;}
".mri"          {strcpy(yylval.label,yytext); return _RESERVED;}
".nolist"       {strcpy(yylval.label,yytext); return _RESERVED;}
".octa"         {strcpy(yylval.label,yytext); return _RESERVED;}
".org"          {strcpy(yylval.label,yytext); return _RESERVED;}
".p2align"      {strcpy(yylval.label,yytext); return _RESERVED;}
".psize"        {strcpy(yylval.label,yytext); return _RESERVED;}
".quad"         {strcpy(yylval.label,yytext); return _RESERVED;}
".rept"         {strcpy(yylval.label,yytext); return _RESERVED;}
".sbttl"        {strcpy(yylval.label,yytext); return _RESERVED;}
".scl"          {strcpy(yylval.label,yytext); return _RESERVED;}
".section"      {strcpy(yylval.label,yytext); return _RESERVED;}
".set"          {strcpy(yylval.label,yytext); return _RESERVED;}
".short"        {strcpy(yylval.label,yytext); return _RESERVED;}
".single"       {strcpy(yylval.label,yytext); return _RESERVED;}
".size"         {strcpy(yylval.label,yytext); return _RESERVED;}
".skip"         {strcpy(yylval.label,yytext); return _RESERVED;}
".space"        {strcpy(yylval.label,yytext); return _RESERVED;}
".stabd"        {strcpy(yylval.label,yytext); return _RESERVED;}
".stabn"        {strcpy(yylval.label,yytext); return _RESERVED;}
".stabs"        {strcpy(yylval.label,yytext); return _RESERVED;}
".string"       {strcpy(yylval.label,yytext); return _RESERVED;}
".symver"       {strcpy(yylval.label,yytext); return _RESERVED;}
".tag"          {strcpy(yylval.label,yytext); return _RESERVED;}
".text"         {strcpy(yylval.label,yytext); return _RESERVED;}
".title"        {strcpy(yylval.label,yytext); return _RESERVED;}
".type"         {strcpy(yylval.label,yytext); return _RESERVED;}
".val"          {strcpy(yylval.label,yytext); return _RESERVED;}
".value"        {strcpy(yylval.label,yytext); return _RESERVED;}
".word"         {strcpy(yylval.label,yytext); return _RESERVED;}
".zero"         {strcpy(yylval.label,yytext); return _RESERVED;}

  /* Other chars */ 

":"           {return (':');}
","           {return (',');}
{id}          {strcpy(yylval.label,yytext); return _ID;}
{par}         {strcpy(yylval.label,yytext); return _ID;}
{string}      {strcpy(yylval.label,yytext); return _ID;}
{other}       {yyerror(yytext);}

%%

void unputstring(char *s) {   
  int l=strlen(s);
  int i;
  for (i=l-1; i>=0; i--) {
    unput(s[i]);
  }
}

