/*
  Optimizer
  GloblEntry header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _GLOBLENTRY_H_
#define _GLOBLENTRY_H_

typedef class Holder *PHolder;
typedef class GloblEntry *PGloblEntry;
typedef class Data *PData;

//
//	Class name : GloblEntry
//
//	Description :
//
class GloblEntry {
  friend Holder;
private:
  char *name;
  unsigned int size;
  PData FownData;
  PData LownData;
  PGloblEntry next;                 // Pointer to the next global id
public:
  GloblEntry(char *s1);             // Constructor
  ~GloblEntry();                    // Destructor

  char *getname(void);              // Returns the name
  char *getalign(void);             // Returns the aligncode
  void setsize(unsigned int s);     // Sets the size
  unsigned int getsize(void);       // Gets the size
  void insert(char *s);             // Inserts a data-field
  bool isEmpty(void);               // Check if ownData is empty
  void putvars(void);               //

  void print(void);                 // Print the entry
};

#endif



