open Protocol

external internal_tracevar : string -> cbid -> unit
      	= "camltk_trace_var"

type textVariable = string

let counter = ref 0

(* Avoid space leak (allow variables are global in Tcl) *)
module StringSet =
  Set.Make(struct type t = string let compare = compare end)
let freelist = ref (StringSet.empty)
let memo = Hashtblc.create 101

(* Added a variable v referenced by widget w *)
let add w v =
  let r = 
    try Hashtblc.find memo w 
    with
      Not_found -> 
      	let r = ref StringSet.empty in
	  Hashtblc.add memo w r;
	  r in
   r := StringSet.add v !r

(* Free variables associated with a widget *)
let freew w =
  try
    let r = Hashtblc.find memo w in
      freelist := StringSet.union !freelist !r;
      Hashtblc.remove memo w 
  with
    Not_found -> ()

let _ = add_destroy_hook freew

(* Allocate a new variable *)
let getv () = 
  let v = 
    if StringSet.is_empty !freelist then begin
      incr counter; 
      "camlv("^ string_of_int !counter ^")"
      end
    else
      let v = StringSet.choose !freelist in
	freelist := StringSet.remove v !freelist;
	v in
    tkEval [| TkToken "set"; TkToken v; TkToken "" |];
    v

let create_temporary w =
  let v = getv() in
    add w v;
    v

let create () = getv ()

(* to be used with care ! *)
let free v =
  freelist := StringSet.add v !freelist

let set v x =
  tkEval [| TkToken "set"; TkToken v; TkToken x |]; ()
let get v =
  tkEval [| TkToken "set"; TkToken v |]

let cCAMLtoTKtextVariable s = TkToken s

let name s = s
let coerce s = s

(* Variable trace *)
let handle vname f =
  let id = new_function_id() in
  let wrapped _ =
    clear_callback id;
    f() in
  Hashtblc.add callback_naming_table id wrapped;
  internal_tracevar vname id
