package biss.awt;

import PSGr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * specialized graphics implementation for postscript printing
 * (with some additional image printing support)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class PostGraphics
  extends PSGr
{
	FileOutputStream FOut = null;
	public static int MaxHeight;
	public static int MaxWidth;
	public static float ScaleX;
	public static float ScaleY;
	static int XRBorder;
	static int YTBorder;
	static int YBBorder;
	static int XLBorder;
	public int CurrentPage = 1;

static {
	//set default device borders [mm]
	setDeviceBorders( 20, 10, 15, 10);
}

public PostGraphics (OutputStream o, Graphics g) {
	super( o, g);
}

public PostGraphics (String pathName, Graphics g) throws IOException {
	super( FOut = new FileOutputStream( pathName), g);
}

public void dispose () {
	os.flush();
	os.close();

	try { FOut.close(); }
	catch ( Exception e) {}
}

public boolean doImage(Image img, int x, int y, int width, int height,
                ImageObserver observer, Color bgcolor) {
	y = transformY(y);

	PostImageConsumer pc = new PostImageConsumer(img);

	os.println("gsave");

	os.println("% build a temporary dictionary");
	os.println("20 dict begin");
	emitColorImageProlog(pc.Width);

	os.println("% lower left corner");
	os.print(x);
	os.print(" ");
	os.print(y);
	os.println(" translate");

	// compute image size. First of all, if width or height is 0, image is 1:1.
	if (height == 0 || width == 0) {
		height = pc.Height;
		width = pc.Width;
	}       

	os.println("% size of image");
	os.print(width);
	os.print(" ");
	os.print(height);
	os.println(" scale");

	os.print(pc.Width);
	os.print(" ");
	os.print(pc.Height);
	os.println(" 8");

	os.print("[");
	os.print(pc.Width);
	os.print(" 0 0 -");
	os.print(pc.Height);
	os.print(" 0 ");
	os.print(0);
	os.println("]");

	os.println("{currentfile pix readhexstring pop}");
	os.println("false 3 colorimage");
	os.println("");


	int offset, sleepyet=0;;
	// array to hold a line of pixel data
	char[] sb = new char[charsPerRow + 1];

	for (int i=0; i<pc.Height; i++) {
		offset = 0;
		++sleepyet;
		if (bgcolor == null) {
			// real color image. We're deliberately duplicating code here
			// in the interest of speed - we don't want to check bgcolor
			// on every iteration.
			for (int j=0; j<pc.Width; j++) {
				int n = pc.Pels[j][i];

				sb[offset++] = hd[(n & 0xF00000) >> 20];
				sb[offset++] = hd[(n & 0xF0000)  >> 16];
				sb[offset++] = hd[(n & 0xF000)   >> 12];
				sb[offset++] = hd[(n & 0xF00)    >>  8];
				sb[offset++] = hd[(n & 0xF0)     >>  4];
				sb[offset++] = hd[(n & 0xF)           ];

				if (offset >= charsPerRow) {
					String s = String.copyValueOf(sb, 0, offset);
					os.println(s);
					if (sleepyet > 5) {
						try {
							// let the screen update occasionally!
							Thread.sleep(15);
						} catch (java.lang.InterruptedException ex) {
							// yeah, so?
						}
						sleepyet = 0;
					}
					offset = 0;
				}
			}
		} else {
			System.out.println("%FalseColor");
			// false color image.
			for (int j=0; j<pc.Width; j++) {
				int bg =
				bgcolor.getGreen() << 16 + bgcolor.getBlue() << 8 + bgcolor.getRed();
				int fg =
				clr.getGreen() << 16 + clr.getBlue() << 8 + clr.getRed();

				int n = (pc.Pels[j][i] == 1 ? fg : bg);

				// put hex chars into string

				sb[offset++] = hd[(n & 0xF0)     ];
				sb[offset++] = hd[(n & 0xF)     ];
				sb[offset++] = hd[(n & 0xF000)  ];
				sb[offset++] = hd[(n & 0xF00)   ];
				sb[offset++] = hd[(n & 0xF00000)];
				sb[offset++] = hd[(n & 0xF0000) ];

				if (offset >= charsPerRow) {
					String s = String.copyValueOf(sb, 0, offset);
					os.println(s);
					if (sleepyet > 5) {
						try {
							// let the screen update occasionally!
							Thread.sleep(15);
						} catch (java.lang.InterruptedException ex) {
							// yeah, so?
						}
						sleepyet = 0;
					}
					offset = 0;
				}
			}
		}   
		// print partial rows
		if (offset != 0) {
			String s = String.copyValueOf(sb, 0, offset);
			os.println(s);
		}
	}

	os.println("");
	os.println("end");
	os.println("grestore");

	return true;
}

public void drawBytes(byte data[], int offset, int length, int x, int y) {
	//resolved to prevent string creation
	y = transformY(y);
	os.print(x);
	os.print(" ");
	os.print(y);
	os.print(" moveto (");
	os.write(data, offset, length);
	os.println(") show stroke");
}

protected void emitProlog() {
	os.println("%!PS-Adobe-2.0 Created by PostGraphics Java PostScript Context");
	os.println("% Based on PSGr by Ernest Friedman-Hill and Sandia National Labs");

	os.println( "%%Page: 1");
	super.setFont( font);
	super.setColor( clr);
	translate( XLBorder, YTBorder);
	scale( ScaleX, ScaleY);
}

public void endDoc () {
	os.println( "showpage");
}

public void newPage () {
	os.println( "showpage");
	os.print( "%%Page: ");
	os.println( ++CurrentPage);
	translate( XLBorder, YTBorder);
	scale( ScaleX, ScaleY);
}

public void psCommand ( String cmd) {
	os.println( cmd);
}

public void setColor (Color c) {
	if ( !clr.equals( c))
		super.setColor( c);
}

public static void setDeviceBorders( int xl, int xr, int yb, int yt){
	// set printer specific bounds ( dots/mm * mm)
	XLBorder = (int)( 2.835 * xl);
	XRBorder = (int)( 2.835 * xr);
	YTBorder = (int)( 2.835 * yt);
	YBBorder = (int)( 2.835 * yb);

	// calculate A4 format pels
	ScaleX    = (float)72 / Awt.XResolution;
	ScaleY    = (float)72 / Awt.YResolution;
	MaxHeight = (int)((842 - YBBorder - YTBorder) / ScaleY);
	MaxWidth  = (int)((594 - XLBorder - XRBorder) / ScaleX);
}

public void setFont (Font f) {
	if ( !font.equals( f))
		super.setFont( f);
}

public void setLineCap ( int c) {
	// 0 butt, 1 round, 2 square
	os.print( c);
	os.println( " setlinecap");
}

public void setLineJoin ( int j) {
	// 0 meter, 1 round, 2 bevel
	os.print( j);
	os.println( " setlinejoin");
}

public void setLineWidth ( int w) {
	//starting from 0
	os.print( w);
	os.println( " setlinewidth");
}

protected int transformY( int y) {
	return MaxHeight - y;
}
}
