package biss.awt;

import biss.ObserverSocket;
import java.util.Observable;
import java.util.Observer;

/**
 * logical view of the standard replace dialog for biss.awt.TextArea
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class TextReplacer
  extends ObserverSocket
  implements Observer
{
	TextReplaceViewer View;
	final public static int FIND = 1;
	final public static int REPLACE = 2;
	int Action;
	final public static int EXIT = 3;

public TextReplacer ( Object selector, Observer owner, TopWindow parent) {
	super ( owner, selector);
	addObserver( owner);

	View = new TextReplaceViewer( parent);
	View.CFind.OsAction.addObserver( this);
	View.CRep.OsAction.addObserver( this);
	View.CExit.OsAction.addObserver( this);	
}

public TextReplacer ( Observer owner, TopWindow parent, String defTxt) {
	this( null, owner, parent);
	setFindText( defTxt);
}

public int action () {
	return Action;
}

public String getFindText () {
	return View.CFindTxt.getContents();
}

public String getReplaceText () {
	return View.CRepTxt.getContents();
}

public void setFindText ( String txt) {
	View.CFindTxt.setContents( txt);
}

public void setReplaceText ( String txt) {
	View.CRepTxt.setContents( txt);
}

public void update ( Observable obs, Object arg ) {
	if ( obs == View.CFind.OsAction){
		Action = FIND;
		notifyObservers();
	}
	else if ( obs == View.CRep.OsAction){
		Action = REPLACE;
		notifyObservers();
	}
	else if ( obs == View.CExit.OsAction){
		Action = EXIT;
		notifyObservers();
		View.dispose();
	}
}
}
