package biss.awt;

import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

/**
 * widget to enter 2-dimensional positios either by a Panner or
 * by SpinButtons.
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Positioner
  extends Compound
  implements Observer
{
	SpinButton XSpin = new SpinButton();
	SpinButton YSpin = new SpinButton();
	Panner Pan = new Panner();
/**
 * triggered by pan drag operation or position fine-tuning
 * via SpinButtons
 * parameter: pan position point (x,y)
 */
	ObserverSocket OsMove = new ObserverSocket( this);
	boolean InvertX = false;
	boolean InvertY = false;

public Positioner () {
	this( 0, 0, 100, 100);
}

public Positioner ( int minX, int minY, int maxX, int maxY) {

	setBorder( Border.BS_INSET);
	XSpin.setRange( minX, maxX);
	YSpin.setRange( minY, maxY);
	Pan.setBackground( Color.lightGray);
	Pan.setPanRect( minX, minY, maxX - minX, maxY - minY);

	Lo.add( Pan,   0, 0, 1000, 1000, false, FBorder.Ext, FBorder.Ext, -FBorder.Ext, -13, 0);
	Lo.add( XSpin, 0, 1000, 500, 1000, true, 0, -130, 0, 0, 0);
	Lo.add( YSpin, 500, 1000, 1000, 1000, true, 0, -130, 0, 0, 0);

	XSpin.OsSpinChanged.addObserver( this);
	YSpin.OsSpinChanged.addObserver( this);
	Pan.OsMove.addObserver( this);
}

public void invertXRange () {
	updateXRange ( -XSpin.Max, -XSpin.Min);
	InvertX = InvertX ? false : true;
}

public void invertYRange () {
	updateYRange ( -YSpin.Max, -YSpin.Min);
	InvertY = InvertY ? false : true;
}

public void setPosition ( int x, int y) {
	Pan.setPosition( x, y);
	XSpin.setContents( x);
	YSpin.setContents( y);
}

public void setXRange ( int min, int max) {
	Pan.setXRange( min, max);
	XSpin.setRange( min, max);
}

public void setYRange ( int min, int max) {
	Pan.setYRange( min, max);
	YSpin.setRange( min, max);
}

public void update (Observable obs, Object arg) {
	if ( obs == XSpin.OsSpinChanged){
		Pan.setPosition( XSpin.CurVal, YSpin.CurVal);
		OsMove.notifyObservers( Pan.Position);
	}
	else if ( obs == YSpin.OsSpinChanged){
		Pan.setPosition( XSpin.CurVal, YSpin.CurVal);
		OsMove.notifyObservers( Pan.Position);
	}
	else if ( obs == Pan.OsMove) {
		XSpin.setContents( ((Point)arg).x);
		YSpin.setContents( ((Point)arg).y);
		OsMove.notifyObservers( Pan.Position);
	}
}

public void updateXRange ( int min, int max) {
	Pan.setXRange( min, max);
	XSpin.updateRange( min, max);
}

public void updateYRange ( int min, int max) {
	Pan.setYRange( min, max);
	YSpin.updateRange( min, max);
}
}
