package biss.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;

/**
 * horizontal splitbar (moveable boundary between widgets to change the
 * layout of a Container)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class HSplitBar
  extends SplitBar
{

public HSplitBar () {
	CursorType = Frame.E_RESIZE_CURSOR;
}

public HSplitBar ( int id ) {
	Id = id;
	CursorType = Frame.E_RESIZE_CURSOR;
}

void computeSiblings () {
	Component childs[] = getParent().getComponents();
	Rectangle b = bounds();
	int i;
	Rectangle r;

	for ( i=0; i<childs.length; i++ ) {
		if ( (childs[i] != this) && (childs[i].isVisible()) ) {
			r = childs[i].bounds();
			if ( r.y < (b.y + b.height) && (r.y + r.height) > r.y ) {
				if ( (Math.abs( b.x - (r.x + r.width)) <= 1) ||
				     (Math.abs( r.x - (b.x + b.width)) <= 1) ) {
					addSibling( childs[i]);
				}
			}
		}
	}
}

public boolean mouseDrag ( Event evt, int x, int y ) {
	int x1 = XPos+X;
	int y2 = YPos+Height - 1;

	Fr.setCursor( CursorType);

	if ( Awt.AwtToolkit == Awt.TK_WIN ) { // WIN bug workaround:
		Insets in = Parent.insets();        // inset coord. paint bug
		PGr.drawLine( x1-in.left, YPos-in.top, x1-in.left, y2-in.top );
		x1 = XPos + x;
		if ( x1 <= Max && x1 >= Min ) {
			X = x;
			PGr.drawLine( x1-in.left, YPos-in.top, x1-in.left, y2-in.top );
		}
		return true;
	}

	PGr.drawLine( x1, YPos, x1, y2 );

	x1 = XPos + x;
	if ( x1 <= Max && x1 >= Min ) {
		X = x;
		PGr.drawLine( x1, YPos, x1, y2 );
	}

	return true;
}

public void paint ( Graphics g ) {

	// infamous ScreenUpdater neutralizer
	if ( RetainPainter != null && RetainPainter.checkPaintSeries() )
		return;

	g.setColor( getBackground());
	g.fillRect( 0, 0, Width, Height);

	int b = 12;
	int w = Width -1;
	g.setColor( Color.white);
	g.drawLine( 0, 0, w, 0);
	g.drawLine( 0, 0, 0, b);
	g.setColor( Color.black);
	g.drawLine( 0, b, w, b);
	g.drawLine( w, 0, w, b);
}

public Dimension preferredSize () {
	return new Dimension( 5, Parent.size().height);
}

void rearrange () {
	Component c;
	Rectangle r;
	int       xNew, wNew;
	int       x = XPos + X;
	int       x2 = XPos + Width;
	int       d;

	for ( Enumeration e=Siblings.elements(); e.hasMoreElements(); ) {
		c = (Component) e.nextElement();
		r = c.bounds();

		if ( r.x >= x2 ) {   // right
			d    = r.x - x2;
			xNew = x + Width + d;
			wNew = r.width + (r.x - xNew);
		}
		else {              // left
			d    = XPos - (r.x + r.width);
			xNew = r.x;
			wNew = x - r.x - d;
		}
		c.reshape( xNew, r.y, wNew, r.height);

		/*** panel bug workaround ***/
		if ( c instanceof Container)
			c.layout();
	}

	move( x, YPos);
}

void updateMoveBoundaries ( Rectangle r ) {
	if ( r.x >= XPos ) {
		int x = r.x+r.width - Width;
		if ( x > Max )
			Max = x;
	}
	if ( r.x < Min )
		Min = r.x;
}
}
