package biss.awt;

import java.awt.Component;
import java.awt.Container;

/**
 * delegation object class to implement a focus switching mechanism for
 * arbitrary container widgets
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class FocusHandler
{

public static void focusNext ( Container co) {
	Component ca[] = co.getComponents();
	int       nc   = co.countComponents();
	FocusSetInterface bc, fbc = null;
	boolean set = false;

	for ( int i=0; i<nc; i++){
		Component c = ca[i];
		if ( (c == null) || ! (c instanceof FocusSetInterface) )
			continue;
		bc = (FocusSetInterface) c;
		//first component that can get focus
		if ( (fbc == null) && (bc.canGetFocus() ) ) 
			fbc = bc;

		if ( set){
			if ( bc.setFocus()){
				return;
			}
		}
		else if ( bc.hasFocus() ){
			if ( bc instanceof Compound) {
				if ( ((Compound)bc).focusNext() )
					return;
			}
			set = true;
		}
	}

	if ( fbc != null)
		fbc.setFocus();
}

public static void focusPrev ( Container co) {
	Component ca[] = co.getComponents();
	int       nc   = co.countComponents();
	FocusSetInterface bc, lbc = null;
	boolean set = false;

	for ( int i=nc - 1; i>=0; i--){
		Component c = ca[i];
		if ( (c == null) || ! (c instanceof FocusSetInterface) )
			continue;
		bc = (FocusSetInterface) c;
		if ( (lbc == null) && ( bc.canGetFocus() ) )
			lbc = bc;
		if ( set){
			if ( bc.setFocus())
				return;
		}
		else if ( bc.hasFocus() ){
			if ( bc instanceof Compound){
				if ( ((Compound)bc).focusPrev() )
					return;
			}
			set = true;
		}
	}

	if ( lbc != null)
		lbc.setFocus();
}

public static boolean includesFocusPart ( Container co) {
	Component ca[] = co.getComponents();
	int       nc   = co.countComponents();

	for ( int i=0; i<nc; i++){
		Component c = ca[i];
		if ( c != null) {
			if ( c instanceof FocusSetInterface){
				FocusSetInterface bc = (FocusSetInterface) c;
				if ( bc.hasFocus() )
					return true;
			}
		}
	}

	return false;
}
}
