package biss.awt;

import biss.DirEnumerator;
import biss.FileExtFilter;
import biss.StringLib;
import biss.VectorLib;
import biss.VectorSorter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/**
 * Implementation of a FileDialog by means of biss.awt classes (NOT
 * native).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
class DirEntry
  implements SelfDrawingObject
{
	File Dir;
	String Name;
	static Image DirImg = ClassImageSource.getImage( "biss.awt.DirImage");

public DirEntry ( File f) {
	Dir = f;
	Name = f.getName();
}

public DirEntry ( File f, String s) {
	Dir = f;
	Name = s;
}

public int drawHeight () {
	return Awt.SysFontHeight;
}

public void drawSelfIn (Object pane) {
	List op			= (List) pane;
	Graphics g	= op.DrawGraphics;
	Rectangle r	= op.DrawRect;
	int x0 			= r.x + Awt.SysFontHeight / 2;

	GraphicsLib.drawImageVCentered( g, DirImg, x0, r.y, r.height, op);

	x0 += Awt.SysFontHeight;
	g.setFont( Awt.SysFont);
	g.drawString( Name, x0,
	              r.y + r.height - (r.height - Awt.SysFontHeight) / 2 -
	              Awt.SysFontDesc );
}

boolean isExpandPos (Point pt) {
	return pt.x < 3 * Awt.SysFontHeight / 2;
}

public String label () {
	return Name;
}

public int maxDrawWidth () {
	return 300;
}
}

public class FileDialog
  extends DialogWindow
  implements Observer, FileDialogPeer
{
	List DirPane = new List();
	List FilePane = new List();
	List DrivePane = new List();
	TextField PathEntry = new TextField();
	Button OkBtn = new Button( "~Ok");
	Button CancelBtn = new Button( "~Cancel");
	DecoText PathText = new DecoText( "File");
	DecoText FilterText = new DecoText( "Filter");
	DecoText DriveText = new DecoText( "Drive");
	DecoText DirText = new DecoText( "Directory");
	DecoText FileText = new DecoText( "Files");
	Choice FilterChoice = new Choice();
	File CurPath;
	Layouter Lo = new Layouter( this);

public FileDialog () {
	this( System.getProperty( "user.home", "."), null);
}

public FileDialog ( String initPath, TopWindow owner) {
	super ( "FileDialog", owner);
	CurPath = new File( initPath);
	open();
}

void checkExpand (Point p) {
	DirEntry de = (DirEntry)DirPane.getSelection();
	if ( ( p == null) || (de.isExpandPos( p) )){
		CurPath = new File( de.Dir.getPath());
		updateDirPane();
	}
}

public File getSelection ( ) {
	return new File( PathEntry.getContents() );
}

void init () {
	DirPane.OsSelection.addObserver( this);
	DirPane.OsMouseSelection.addObserver( this);
	DirPane.OsProcess.addObserver( this);
	FilePane.OsSelection.addObserver( this);
	FilePane.OsProcess.addObserver( this);
	DrivePane.OsSelection.addObserver( this);
	PathEntry.OsEnter.addObserver( this);
	FilterChoice.OsSelection.addObserver( this);
	OkBtn.OsAction.addObserver( this);
	CancelBtn.OsAction.addObserver( this);

	initDrives();
	initFilter();
	updateDirPane();
}

void initDrives () {
	Vector v = new Vector();
	if( (Awt.AwtToolkit == Awt.TK_WIN) ||
	    (Awt.AwtToolkit == Awt.TK_OS2) ){
		String[] das = { "C:", "D:", "E:", "F:", "G:", "H:" };
		for ( int i=0; i<das.length; i++){
			File da = new File( das[i] + File.separator);
			if ( da.exists() )
				v.addElement( das[i]);
		}
	}
	else
		v.addElement( File.separator);

	DrivePane.setContents( v);    
}

void initFilter () {
	String[] fa = { ".*", ".java", ".class" };
	FilterChoice.setContents( VectorLib.vectorFromArray( fa));
}

public static void main ( String[] args ) {
	new FileDialog();
}

public void open () {
	Lo.add( PathText,     0,    0,   0,    0,    true, 50,   50,  300,  250,  0);
	Lo.add( PathEntry,    0,    0,   1000, 0,    true, 300,  50,  -50,  250,  0);
	Lo.add( DriveText,    0,    0,   0,    0,    true, 50,   250, 300,  350,  0);
	Lo.add( DrivePane,    0,    0,   0,    1000, true, 50,   350, 300, -300,  0);
	Lo.add( DirText,      0,    0,   600,  0,    true, 300,  250,   0,  350,  0);
	Lo.add( DirPane,      0,    0,   600,  1000, true, 300,  350,   0, -300,  4);
	Lo.add( FileText,     600,  0,   1000, 0,    true, 0,    250, -50,  350,  0);
	Lo.add( FilePane,     600,  0,   1000, 1000, true, 0,    350, -50, -300,  0);

	Lo.add( FilterText,   700,  1000,  700, 1000,  true, 0,  -250, 300, -50,  0);
	Lo.add( FilterChoice, 700,  1000,  1000, 1000, true, 300,-250, -50, -50,  0);

	Lo.add( OkBtn,        0,   1000, 333, 1000, true, 50, -250, -20,  -50, 0);
	Lo.add( CancelBtn,    333, 1000, 666, 1000, true, 20, -250, -20,  -50, 0);

	init();

	if ( Bounds != null)
		openIn( Bounds);
	else
		openInDlgUnits( 0, 0, 2500, 2000);
}

public void setDirectory (String dir ) {
	//java.awt.peer.FileDialogPeer interface
	File f = new File( dir);
	if ( f.exists() && f.isDirectory() && f.canRead() )
		CurPath = f;
	updateDirPane();
}

public void setFile (String file ) {
	//java.awt.peer.FileDialogPeer interface
	File f = new File( file);
	if ( f.exists() && f.canRead() )
		CurPath = new File( f.getPath());
	updateDirPane();
	DirPane.setSelection( CurPath, true);
	FilePane.setSelection( f.getName(), true );
}

public void setFilenameFilter( FilenameFilter filter ) {
	//java.awt.peer.FileDialogPeer interface
	if ( filter instanceof FileExtFilter){
		FilterChoice.setSelection( ((FileExtFilter)filter).extension() );
		updateFiles();
	}
}

public void update ( Observable obs, Object arg ) {
	if ( obs == PathEntry.OsEnter){
		File f = new File( PathEntry.getContents() );
		if ( f.exists() ){
			CurPath = f;
			if ( f.isDirectory() )
				updateDirPane();
			else
				process();
		} 
	}
	else if ( obs == FilterChoice.OsSelection)
		updateFiles();
	else if ( obs == DrivePane.OsSelection){
	}
	else if ( obs == DirPane.OsSelection)
		updateFiles();
	else if ( obs == DirPane.OsProcess)
		checkExpand( null);
	else if ( obs == DirPane.OsMouseSelection)
		checkExpand( (Point)arg);
	else if ( obs == FilePane.OsSelection)
		updatePath();
	else if ( obs == FilePane.OsProcess)
		process();
	else if ( obs == OkBtn.OsAction)
		process();
	else if ( obs == CancelBtn.OsAction)
		dispose();
	else
		super.update( obs, arg);
}

public void updateDirPane ( ) {
	Vector v = new Vector();
	DirEnumerator de = new DirEnumerator( CurPath.getPath(), 1);
	for ( Enumeration e = de.elements(); e.hasMoreElements();)
		v.addElement( new DirEntry( (File)e.nextElement()) );

	v.setElementAt( new DirEntry( new File( CurPath.getPath()), "."), 0);
	if ( ! CurPath.getPath().equals( File.separator)){
		String pd = CurPath.getParent();
		if ( pd == null) pd = File.separator;
		v.insertElementAt( new DirEntry( new File( pd), ".."), 1);
	}

	DirPane.setContents( v);
	FilePane.setContents( null);
	PathEntry.setContents( CurPath.getPath() );
}

void updateFiles () {
	DirEntry de = (DirEntry)DirPane.getSelection();
	if ( de != null) {
		CurPath = de.Dir;
		String[] fls = CurPath.list( new FileExtFilter( (String)FilterChoice.getSelection()));
		Vector v = VectorLib.vectorFromArray( fls);
		VectorLib.quickSort( v, new FileSorter() );
		PathEntry.setContents( CurPath.getPath() );
		FilePane.setContents( v);
	}
}

void updatePath () {
	String file = (String)FilePane.getSelection();
	if ( file != null)
		PathEntry.setContents( CurPath.getPath() + File.separator + file);
}
}

class FileSorter
  implements VectorSorter
{

public int compare (Object a, Object b) {
	String f1 = (String)a;
	String f2 = (String)b;
	return f1.compareTo( f2);
}
}
