package biss.awt;

import java.awt.Color;
import java.awt.Decoration;
import java.awt.FontMetrics;
import java.awt.Graphics;

/**
 * static decoration group (box with text in upper left corner)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DecoGroup
  extends DecoBox
{
	String Name = "";
	int Len;
	static FontMetrics Fm;
	static int Dy;
	static int Asc;
	static int Dx;
	boolean Carved;
	public static boolean DefaultCarved = true;

static {
	Fm = Awt.getFontMetrics( Awt.StaticFont);
	Dy = Fm.getHeight() / 2;
	Asc = Fm.getAscent();
	Dx = Awt.SysFontWidth * 2;
}

public DecoGroup () {
	this( "");
}

public DecoGroup ( String name ) {
	Name = name;
	Len = Fm.stringWidth( Name);
	setCarved( DefaultCarved);
	setForeground( Awt.StaticForeClr);
}

public void blank (Graphics g, Color cb) {
	BoxBorder.blankBorder( g, X, Y+Dy, Width, Height-Dy, cb);
	blankNameBox( g, cb);
}

public void blankNameBox (Graphics g, Color cb) {
	int x = X + Dx - 4;
	g.setColor( cb );
	g.fillRect( x, Y, Len+6, Fm.getHeight()+1 );
}

public void paint ( Graphics g ) {
	if ( ! isShowing() )
		return;

	BoxBorder.drawBorder( g, X, Y+Dy, Width, Height-Dy);
	blankNameBox( g, getParent().getBackground() );

	g.setFont( Awt.StaticFont);
	GraphicsLib.drawString( g, Name, X + Dx, Y + Asc, 
	                        getForeground(), Carved);
}

public void setCarved (boolean c ) {
	Carved = c;
	setBorder( c ? Border.BS_CARVED : Border.BS_PLAIN);
}

public static void setDefaultCarved ( boolean c ) {
	DefaultCarved = c;
}

public void setName (String name ) {
	int len = Fm.stringWidth( name);

	Name = name;

	if ( isShowing() ){
		Graphics g = getGraphics();
		if ( g != null ) {
			blankNameBox( g, getParent().getBackground() ); //needs old length for blank
			Len = len;
			paint( g);
			g.dispose();
		}
	}
	else
		Len = len;
}
}
