package biss.awt;

import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Decoration;
import java.awt.Graphics;

/**
 * generic decoration support via ObserverSocket
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DecoGraph
  extends DecoBox
{
	ObserverSocket OsPaint = new ObserverSocket( this);

public DecoGraph () {
	super( Border.BS_NONE);
}

public void blank (Graphics g, Color cb) {
	g.setColor( cb);
	g.fillRect( X, Y, Width+1, Height+1);
}

public void paint( Graphics g) {
	if ( ! isShowing() )
		return;
	OsPaint.notifyObservers( g);
	drawBorder( g);
}
}
