package biss.awt;

import biss.FileLib;
import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Observable;

/* (compiler bug, second '*' causes compile error)
 * replaces java.awt.Button
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Button
  extends Control
  implements HotKeyProcessor, ButtonPeer
{
	boolean Alert = false;
	int BorderWidth = Awt.BorderWidth;
	FontMetrics Fm;
/**
 * triggered by Mouse1Up, SpaceBar or Enter key to notify about
 * an action event
 * parameter: this
 */
	public ObserverSocket OsAction = new ObserverSocket( this);
/**
 * triggered by painting just in case of at least one registered
 * observer. This observer is responsible for all inner painting
 * e.g. overrides standard painting
 * parameter: this
 */
	public ObserverSocket OsDraw = new ObserverSocket( this);
	boolean Pushed = false;
	boolean Raise = false;
	String Selector = null;
	String Text = null;
	Point PMn = null;
	char MnKey = 0;
	static FontMetrics DefFm;
	Image Img;
	public static boolean DefaultCarved = true;
	boolean Carved;

static {
	DefFm = Awt.getFontMetrics( Awt.ButtonFont);
}

public Button() {
	this( "", null, null);
}

public Button( String text) {
	this( text, null, null);
}

public Button( String text, Font fnt){
	this( text, null, fnt);
}

public Button( String pathName, String text) {
	this( text, null, null);
	setImage( pathName, text);
}

public Button( String text, String sel, Font fnt) {

	Carved = DefaultCarved;
	EventHandler.CursorType = Awt.ActionCursor;
	setForeground( Awt.ButtonForeClr);
	setBackground( Awt.ButtonBackClr);

	setFont( fnt);
	setContents( text);

	Selector = ( sel != null) ? sel : Text;
}

public Button( java.awt.Button peerTarget){
	// create peer object for java.awt.Button
	this( peerTarget.getLabel() );
	setPeerTarget( peerTarget); // this one will set fonts and colors
	addNotify();
}

public void addNotify () {
	super.addNotify();

	TopWindow tw = getTopWindow();
	if ( (MnKey != 0) && ( tw != null) )
		tw.addGlobalHotKey( MnKey | 32, this, null);
}

void animate ( boolean upd) {

	Pushed = true;
	Raise = true;
	redrawImmediate();

	try { Thread.sleep(100);}
	catch ( InterruptedException x ){}

	Pushed = false;
	Raise = false;
	if ( upd)
		redrawImmediate();
}

public void charInput( char c, int mod) {
	if ( c == ' ')
		trigger();
}

void drawImage( Graphics g) {
	int w = ! Pushed  ? Width : Width + 2 * BorderWidth;
	int h = ! Pushed  ? Height : Height + 2 * BorderWidth;
	GraphicsLib.drawImageCentered( g, Img, w, h, this);
}

void drawImageText( Graphics g ) {    
	int iw = Img.getWidth( this);
	int ih = Img.getHeight( this);

	//prevent flicker ( will be drawn on image complete)
	if ( (iw == 0) || (ih == 0) )
		return;

	int th = Fm.getHeight() + ih;
	int fd = Fm.getDescent();
	int dof = Pushed ? 1 : 0;
	int y = Height - ( Height - th +1) / 2 - fd; 
	int x = (Width - Fm.stringWidth( Text)) / 2;

	if ( ! Alert && Carved) {
		g.setColor( Awt.ShadowBrightClr);
		g.drawString( Text, x+dof+1, y+dof+1);
	}

	if ( EventHandler.IsDisabled )
		g.setColor( Awt.InactiveClr);
	else
		g.setColor( Alert ? Awt.ButtonAlertForeClr : Awt.ButtonForeClr);

	g.drawString( Text, x+dof, y+dof);

	if ( PMn != null){
		g.setColor( Color.blue);
		g.drawLine( x+dof+PMn.x, y+dof+1, x+dof+PMn.y, y+dof+1);
	}

	g.drawImage( Img, (Width-iw) / 2 + dof, y+fd-th+dof, this);
}

void drawText( Graphics g){
	int y = Height - ( Height - Fm.getHeight() + 1) / 2 - Fm.getDescent();
	int x = (Width - Fm.stringWidth( Text)) / 2;

	if ( !Raise && Pushed ) {
		x += 1; y += 1;
	}

	drawText( g, x, y);
}

void drawText( Graphics g, int x, int y ) {    

	if ( ! Raise ) {
		if ( ! Alert && Carved ) {
			g.setColor( Awt.ShadowBrightClr);
			g.drawString( Text, x+1, y+1);
		}
		if ( EventHandler.IsDisabled )
			g.setColor( Awt.InactiveClr);
		else
			g.setColor( Alert ? Awt.ButtonAlertForeClr : Awt.ButtonForeClr);
		g.drawString( Text, x, y);
	}
	else {
		GraphicsLib.flashText( g, Text, x, y);
	}

	if ( PMn != null){
		g.setColor( Color.blue);
		g.drawLine( x+PMn.x, y+1, x+PMn.y, y+1);
	}
}

public String getContents(){
	return Text;
}

public void gotFocus(){
	redraw();
}

public void lostFocus(){
	redraw();
}

public int minWidth() {
	if ( Text == null)
		return 0;
	return Fm.stringWidth( Text);
}

public void mouse1Down( Event evt){
	if ( isEnabled() ) {
		Pushed = true;
		redraw();
	}
}

public void mouse1Drag( Event evt){
	if ( ! isEnabled() )
		return;

	if ( (evt.x > 0) && (evt.x < Width) &&
	     (evt.y > 0) && (evt.y < Height)){
		if ( ! Pushed){
			Pushed = true;
			redraw();
		}
	}
	else if ( Pushed){
		Pushed = false;
		redraw();	
	}					
}

public void mouse1Up( Event evt){
	if ( Pushed){
		Pushed = false;
		trigger();
	}
}

public Dimension preferredSize(){
	return new Dimension( 7*Awt.SysFontWidth, 3*Awt.SysFontHeight/2);
}

public void processKey( Object sel){
	trigger();
}

protected void redraw ( Graphics g) {
	int b = BorderWidth;
	int b2 = b*2;

	g.setColor( Alert ? Awt.ButtonAlertBackClr : Awt.ButtonBackClr);
	g.fillRect( b, b, Width-b2, Height-b2);

	if ( ! OsDraw.isEmpty() )	OsDraw.notifyObservers( this);
	else if ( Img  != null) {
		if ( Text != null) drawImageText( g);
		else               drawImage( g);
	}
	else if ( Text != null)	drawText( g);

	GraphicsLib.paintButton( g, 0, 0, Width, Height, Pushed, null);

	if ( EventHandler.HasFocus )
		GraphicsLib.drawFocusMark( g, Awt.BorderWidth, Awt.BorderWidth,
	                           Awt.FocusMarkWidth);
}

public void setAlert ( boolean alert ) {
	Alert = alert;
	redraw();
}

public void setCarved( boolean c){
	Carved = c;
	redraw();
}

public void setContents( String cont){
	if ( cont != null){
		if ( cont.endsWith( ".gif"))	setImage( cont);
		else													setLabel( cont);
	}
}

public static void setDefaultCarved( boolean c){
	DefaultCarved = c;
}

public synchronized void setFont( Font fnt) {
	Font uf = ( fnt != null) ? fnt : Awt.ButtonFont;

	if ( getFont() == uf )
		return;

	super.setFont( uf);

	if ( uf.equals( Awt.ButtonFont) )
		Fm = DefFm;
	else
		Fm = Awt.DefToolkit.getFontMetrics( uf);

	if ( isShowing() )
		redraw();
}

public void setImage( Image img){
	setImage( img, null);
}

public void setImage( Image img, String label){
	Text = label;
	Img  = img;
	if ( Text != null ){
		setFont( Awt.ButtonImageFont);
		splitLabel();
	}
	if ( isShowing() )
		redraw();
}

public boolean setImage( String pathName){
	return setImage( pathName, null);
}

public boolean setImage( String pathName, String label){
	Image img = Awt.getImage( pathName);
	if ( img != null){
		setImage( img, label);
		return true;
	}
	System.out.println( "cannot find imagefile: " + pathName);
	return false;
}

public boolean setImageClass( String imgCls){
	return setImage( imgCls, null);
}

public boolean setImageClass( String imgCls, String label){
	Image img = ClassImageSource.getImage( imgCls);
	if ( img != null){
		setImage( img, label);
		return true;
	}
	return false;
}

public void setImageText( String label){
	Text = label;
	setFont( Awt.ButtonImageFont);
	splitLabel();
	if ( isShowing() )
		redraw();
}

public void setLabel( String label){
	//java.awt.peer.ButtonPeer interface
	Img  = null;
	Text = label;
	splitLabel();
	setFont( Awt.ButtonFont);
}

public void setTextImage( Image img){
	Img  = img;
	setFont( Awt.ButtonImageFont);
}

void splitLabel() {
	char mn = '~';
	String rStr;
	int xb, xe, idx = Text.indexOf( mn);

	if ( idx > -1){   
		rStr = Text.substring( 0, idx);
		xb = Fm.stringWidth( rStr);
		Text = rStr + Text.substring( idx+1);
		xe = xb + Fm.charWidth( Text.charAt( idx));
		MnKey = Text.charAt( idx);
		PMn = new Point( xb, xe);
	}

}

public void trigger (){
	if ( isEnabled() ) {
		animate( true);
		OsAction.notifyObservers( this);
		peerEvent( Event.ACTION_EVENT, Text);
	}
}

public boolean vKeyInput( int code, int mod) {

	switch ( code) {
	case Key.Newline:
		trigger();
		break;
	default:
		return false;
	}

	return true;
}
}
