package biss.calendar;

import biss.PackageProperties;
import biss.awt.Awt;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;

/**
 * Spezifikation der Eigenschaften fr biss.calendar package Klassen
 * Initialisierung ber property file ~\.java\biss.calendar
 */
public class Calendar
{
	public static PackageProperties Values = new PackageProperties( "biss.calendar");
	public static String[] Categories;
	public static int DayStartHour;
	public static int DayEndHour;
	public static int DayTimeSlot;
	public static String DefDateFile;
	public static Font SmallFont;
	public static Font TextFont;
	public static int WatchDelay;
	public static FontMetrics TextFontMetrics;
	public static FontMetrics SmallFontMetrics;
	public static Font LargeFont;
	public static FontMetrics LargeFontMetrics;

static {
	Categories = Values.getStrings( "Categories", ";:,", "private,business,very important");
	DayStartHour = Values.getInt( "DayStartHour", 8);
	DayEndHour   = Values.getInt( "DayEndHour", 20);
	DayTimeSlot  = Values.getInt( "DayTimeSlot", 20);
	WatchDelay   = Values.getInt( "WatchDelay", 5);
	DefDateFile  = Values.getString( "DefDateFile", "dates.dat" );
	SmallFont    = Values.getFont( "SmallFont", "Helvetica PLAIN 10");
	TextFont     = Values.getFont( "TextFont",  "Helvetica BOLD 12");
	LargeFont    = Values.getFont( "LargeFont", "Helvetica BOLD 14");

	SmallFontMetrics = Awt.DefToolkit.getFontMetrics( SmallFont);
	TextFontMetrics  = Awt.DefToolkit.getFontMetrics( TextFont);
	LargeFontMetrics = Awt.DefToolkit.getFontMetrics( LargeFont);

}
}
