package biss;

import java.io.File;
import java.io.FilenameFilter;

/**
 * File extension filter
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class FileExtFilter
  implements FilenameFilter
{
	String Extension;

public FileExtFilter ( String extension ) {
	Extension = extension;
}

public boolean accept ( File dir, String name ) {
	if ( (new File( dir, name)).isDirectory() ) return false;
	if ( Extension.equals( ".*")) return true;
	return ( name.endsWith( Extension) );
}

public String extension(){
	return Extension;
}
}
