package biss;

import biss.VectorLib;
import biss.VectorSorter;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Vector;

/**
 * class to recursivly scan directory trees which can be accessed by the
 * standard java.util.Enumeration interface. Directories are sorted 
 * alphabeticaly
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class DirEnumerator
{
	Vector DirList;
	FilenameFilter Filter;
	DirSorter Sorter;
	int Level = 0;
	int MaxLevel = 100;

public DirEnumerator ( FilenameFilter filter, Vector dirList ) {
	Filter = filter;
	Sorter = new DirSorter();
	DirList = dirList;
}

public DirEnumerator ( String dirName ) {
	Filter = new DirFilter();
	Sorter = new DirSorter();
	DirList = new Vector(20);

	getDirTree( dirName);
}

public DirEnumerator ( String dirName, FilenameFilter filter ) {
	Filter = filter;
	Sorter = new DirSorter();
	DirList = new Vector( 20);

	getDirTree( dirName);
}

public DirEnumerator (String dirName, FilenameFilter filter, Vector dirList){
	Filter = filter;
	Sorter = new DirSorter();
	DirList = dirList;

	getDirTree( dirName);
}

public DirEnumerator ( String dirName, int maxLvl ) {
	Filter = new DirFilter();
	Sorter = new DirSorter();
	DirList = new Vector(20);
	MaxLevel = maxLvl;
	getDirTree( dirName);
}

public Enumeration elements () {
	return DirList.elements();
}

public Vector getDirList() {
	return DirList;
}

public void getDirTree ( String dirName ) {
	File dir = new File( dirName);
	if ( dir.isDirectory() )
		traverseDir( dir);
}

public static void main ( String[] args ) {
	DirEnumerator de = new DirEnumerator( args[0]);

	for ( Enumeration e = de.elements(); e.hasMoreElements(); )
		System.out.println( e.nextElement());
}

public int size () {
	return DirList.size();
}

private void traverseDir ( File dir ) {
	if ( (Level > MaxLevel) || (! dir.canRead() ))
		return;
	Level++;

	VectorLib.sortIn( DirList, dir, Sorter);
	String[] subs = dir.list( Filter);
	for ( int i=0; i<subs.length; i++ )
		traverseDir( new File( dir, subs[i]));

	Level--;
}
}

class DirSorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	String pa = ((File)a).getAbsolutePath();
	String pb = ((File)b).getAbsolutePath();

	return pa.compareTo( pb);
}
}
