;; ---------------------------------------------------------------------- ;;
;! @file     format.scm                                                   !;
;! @created  Tue Jun 17 14:42:09 1997                                     !;
;! @modified Tue Jun 17 14:43:31 1997                                     !;
;; ---------------------------------------------------------------------- ;;
;! @copyright Dominique Boucher                                           !;
;; ---------------------------------------------------------------------- ;;
;; The format function                                                    ;;
;; ---------------------------------------------------------------------- ;;

(module format
	(export 
	 (format dest str . args)))

;; ---------------------------------------------------------------------- ;;
;; The CL-like format function                                            ;;
;; ---------------------------------------------------------------------- ;;
;! @description 
;!   CL-like formatting function
;! @ignore
(define (format dest str . args)
  (if (not (or (output-port? dest) (boolean? dest)))
      (error "format" "Destination must be an output port or a boolean." dest)
      (let ((in-string (open-input-string str))
	    (out-string (open-output-string)))
	(letrec 
	    ((build-string
	      (lambda (arg-list)
		(let ((next (read-char in-string)))
		  (if (eof-object? next)
		      (begin
			(close-input-port in-string)
			(close-output-port out-string))
		      (if (char=? next #\~)
			  (let ((next2 (read-char in-string)))
			    (cond
			     ((eof-object? next2)
			      (begin
				(display next out-string)
				(close-input-port in-string)
				(close-output-port out-string)))
			     ((char=? next2 #\s)
			      (if (null? arg-list)
				  (error "format" "Not enough replacement arguments." arg-list)
				  (begin
				    (write (car arg-list) out-string)
				    (build-string (cdr arg-list)))))
			     ((char=? next2 #\a)
			      (if (null? arg-list)
				  (error "format" "Not enough replacement arguments." arg-list)
				  (begin
				    (display (car arg-list) out-string)
				    (build-string (cdr arg-list)))))
			     ((char=? next2 #\%)
			      (begin
				(write-char #\newline out-string)
				(build-string arg-list)))
			     (else (begin
				     (display next out-string)
				     (display next2 out-string)
				     (build-string arg-list)))))
			  (begin
			    (display next out-string)
			    (build-string arg-list))))))))
	  (let ((output (build-string args)))
	    (cond
	     ((not dest) output)
	     ((output-port? dest) (display output dest))
	     (else (display output (current-output-port)))))))))

