;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9/Rgc/accept.scm            */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu May 30 09:46:36 1991                          */
;*    Last change :  Wed Feb 19 13:28:46 1997 (serrano)                */
;*                                                                     */
;*    Quelles sont les transitions acceptantes ?                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_accept
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
     
   (export (make-accept-function nb-states states)))

;*---------------------------------------------------------------------*/
;*     make-accept-function ...                                        */
;*---------------------------------------------------------------------*/
(define (make-accept-function nb-states states)
   (let ((t-state-type    (make-vector nb-states '()))
	 (accept-action*  'dummy)
	 (leave-out?      'dummy))
;*---- accept?    -----------------------------------------------------*/
;*   Cette fonction fait deux effets de bords:                         */
;*      - un sur accept-action*                                        */
;*      - un sur leave-out?                                            */
;*---------------------------------------------------------------------*/
      (lambda fun
	 (case (car fun)
	    ((leave-out?)
	     leave-out?)
	    (else
	     (let ((state-num (car fun)))
		;; a-t-on deja calcule les caracteristiques de cet etat?
		(let ((ref (vector-ref t-state-type state-num)))
		   (if (not (null? ref))
		       ;; oui
		       (begin
			  (set! accept-action* (car ref))
			  (set! leave-out?     (cdr ref))
			  accept-action*)
		       ;; non
		       (begin
			  (set! accept-action* '())
			  (set! leave-out? #f)
			  (let loop ((t* (vector-ref states state-num)))
			     (if (null? t*)
				 (begin
				    (vector-set! t-state-type 
						 state-num 
						 (cons accept-action*
						       leave-out?))
				    accept-action*)
				 (let ((pr* (car t*)))
				    (if (not (char? (car pr*)))
					;; Oui, cet etat est accepte pr*
					(for-each
					 (lambda (ok)
					    (set! accept-action* 
						  (insort! ok accept-action*)))
					 pr*)
					;; Cet etat est leave-out
					(set! leave-out? #t))
				    (loop (cdr t*))))))))))))))

;*---------------------------------------------------------------------*/
;*     insort! ...                                                     */
;*---------------------------------------------------------------------*/
(define (insort! quoi dans)
   (cond 
      ((null? dans) 
       (cons quoi '()))
      ((>fx quoi (car dans)) 
       (set-cdr! dans (insort! quoi (cdr dans)))
       dans)
      (else
       (set-cdr! dans (cons (car dans) (cdr dans)))
       (set-car! dans quoi)
       dans)))
