;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/port.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 20 16:53:27 1995                          */
;*    Last change :  Thu Mar  5 07:48:12 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.1 Ports (page 29, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_ports_6_10_1

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool  c-input-port?  (obj)             "INPUT_PORTP")
	    (macro bool  c-output-port? (obj)             "OUTPUT_PORTP")
	    (output-port c-current-output-port           "current_output_port")
	    (output-port c-current-error-port             "current_error_port")
	    (input-port  c-current-input-port             "current_input_port")
	    (obj         c-open-input-file (bstring obj)  "open_input_file")
	    (obj         c-open-input-string (bstring)    "open_input_string")
	    (obj         c-open-output-file  (bstring)    "open_output_file")
	    (obj         c-append-output-file (bstring)   "append_output_file")
	    (obj         c-open-output-string ()          "open_output_string")
	    (obj         c-close-input-port  (obj)        "close_input_port")
	    (obj         c-close-output-port (obj)        "close_output_port")
	    (long        c-default-io-bufsiz              "default_io_bufsiz")
	    (bool        c-reset-eof         (obj)        "reset_eof")
	    (macro obj  c-flush-output-port (output-port) "FLUSH_OUTPUT_PORT")
	    (bool       c-fexists?          (string)      "fexists")
	    (macro bool c-delete-file       (string)        "unlink")
	    (macro bool c-delete-directory  (string)        "rmdir")
	    (macro int  c-rename-file       (string string) "rename"))
   
   (export  (call-with-input-file  ::bstring ::procedure)
	    (call-with-output-file ::bstring ::procedure)

	    (inline input-port?    ::obj)
	    (inline output-port?   ::obj)
	    (inline port?::bool    ::obj)
	    
	    (inline current-input-port::input-port) 
	    (inline current-error-port::output-port)
	    (inline current-output-port::output-port)
	    
	    (with-input-from-file ::bstring ::procedure)
	    (with-output-to-file  ::bstring ::procedure)
	    
	    (with-error-to-file   ::bstring ::procedure)
	    (with-error-to-port   ::output-port ::procedure)
	    
	    (open-input-file                       ::bstring . bufsiz)
	    (inline open-input-string              ::bstring)
	    (inline open-output-file               ::bstring)
	    (inline append-output-file             ::bstring)
	    (inline open-output-string)
	    (inline close-input-port               ::input-port)
	    (inline close-output-port              ::output-port)
	    (inline flush-output-port              ::output-port)
	    (inline reset-eof::bool                ::input-port)
	    
	    (inline file-exists?     ::string)
	    (inline delete-file      ::string)
	    (inline delete-directory ::string)
	    (inline rename-file      ::string ::string))
   
   (pragma  (c-input-port? (predicate-of input-port))
	    (c-output-port? (predicate-of output-port))
	    (file-exists? side-effect-free)))
   

;*---------------------------------------------------------------------*/
;*    call-with-input-file ...                                         */
;*---------------------------------------------------------------------*/
(define (call-with-input-file string proc)
   (let ((port (open-input-file string)))
      (if (input-port? port)
	  (let ((res (proc port)))
	     (close-input-port port)
	     res)
	  (error "call-with-input-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    call-with-output-file ...                                        */
;*---------------------------------------------------------------------*/
(define (call-with-output-file string proc) 
   (let ((port (open-output-file string)))
      (if (output-port? port)
	  (let ((res (proc port)))
	     (close-output-port port)
	     res)
	  (error "call-with-output-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    input-port? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (input-port? obj)
   (c-input-port? obj))

;*---------------------------------------------------------------------*/
;*    output-port? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (output-port? obj)
   (c-output-port? obj))

;*---------------------------------------------------------------------*/
;*    current-input-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (current-input-port)
   c-current-input-port)

;*---------------------------------------------------------------------*/
;*    current-output-port ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (current-output-port)
   c-current-output-port)

;*---------------------------------------------------------------------*/
;*    current-error-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (current-error-port)
   c-current-error-port)

;*---------------------------------------------------------------------*/
;*    with-input-from-file ...                                         */
;*---------------------------------------------------------------------*/
(define (with-input-from-file string thunk)
   (let ((port (open-input-file string)))
      (if (input-port? port)
	  (let ((old-input-port (current-input-port)))
	     (unwind-protect
		(begin
		   (set! c-current-input-port port)
		   (thunk))
		(begin
		   (set! c-current-input-port old-input-port)
		   (close-input-port port))))
	  (error "with-input-from-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    with-output-to-file ...                                          */
;*---------------------------------------------------------------------*/
(define (with-output-to-file string thunk)
   (let ((port (open-output-file string)))
      (if (output-port? port)
	  (let ((old-output-port (current-output-port)))
	     (unwind-protect
		(begin
		   (set! c-current-output-port port)
		   (thunk))
		(begin
		   (set! c-current-output-port old-output-port)
		   (close-output-port port))))
	  (error "with-output-to-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    with-error-to-file ...                                           */
;*---------------------------------------------------------------------*/
(define (with-error-to-file string thunk)
   (let ((port (open-output-file string)))
      (if (output-port? port)
	  (let ((old-output-port (current-error-port)))
	     (unwind-protect
		(begin
		   (set! c-current-error-port port)
		   (thunk))
		(begin
		   (set! c-current-error-port old-output-port)
		   (close-output-port port))))
	  (error "with-error-to-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    with-error-to-port ...                                           */
;*---------------------------------------------------------------------*/
(define (with-error-to-port port thunk)
   (let ((old-output-port (current-error-port)))
      (unwind-protect
	 (begin
	    (set! c-current-error-port port)
	    (thunk))
	 (set! c-current-error-port old-output-port))))

;*---------------------------------------------------------------------*/
;*    open-input-file ...                                              */
;*---------------------------------------------------------------------*/
(define (open-input-file string . bufsiz)
   (let ((size (if (null? bufsiz)
		   c-default-io-bufsiz
		   (car bufsiz))))
      (if (not (integer? size))
	  (error "open-input-file" "not a number" size)
	  (c-open-input-file string size))))

;*---------------------------------------------------------------------*/
;*    open-input-string ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (open-input-string string)
   (c-open-input-string string))

;*---------------------------------------------------------------------*/
;*    open-output-file ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (open-output-file string)
   (c-open-output-file string))

;*---------------------------------------------------------------------*/
;*    open-output-string ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (open-output-string)
   (c-open-output-string))

;*---------------------------------------------------------------------*/
;*    close-input-port ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (close-input-port port)
   (c-close-input-port port))

;*---------------------------------------------------------------------*/
;*    close-output-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (close-output-port port)
   (c-close-output-port port))

;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    flush-output-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (flush-output-port port)
   (c-flush-output-port port))

;*---------------------------------------------------------------------*/
;*    reset-eof ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (reset-eof port)
   (c-reset-eof port))

;*---------------------------------------------------------------------*/
;*    file-exists? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (file-exists? name)
   (c-fexists? name))
   
;*---------------------------------------------------------------------*/
;*    append-output-file ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (append-output-file string)
   (c-append-output-file string))

;*---------------------------------------------------------------------*/
;*    delete-file ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (delete-file string)
   (c-delete-file string))

;*---------------------------------------------------------------------*/
;*    delete-directory ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (delete-directory string)
   (c-delete-directory string))

;*---------------------------------------------------------------------*/
;*    rename-file ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (rename-file string1 string2)
   (if (eq? (c-rename-file string1 string2) 0)
       #t
       #f))

;*---------------------------------------------------------------------*/
;*    port? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (port? obj)
   (or (output-port? obj) (input-port? obj)))
