;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9b/Ieee/number.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 24 09:59:43 1995                          */
;*    Last change :  Mon Apr 14 11:33:44 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4)                                       */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5
   
   (import  (__error                   "Llib/error.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro double c-fixnum->flonum (long)   "(double)")
	    (macro long   c-flonum->fixnum (double) "(long)"))
   
   (export  (inline number?::bool           obj)
	    (inline exact?::bool            z)
	    (inline inexact?::bool          z)
	    (complex?::bool                 x)
	    (rational?::bool                x)
	    (inline flonum->fixnum::long    x)
	    (inline fixnum->flonum::double  x)
	    (2=::bool                       x y)
	    (=::bool                        x y . z)
	    (2<::bool                       x y) 
	    (<::bool                        x y . z)
	    (2>::bool                       x y)
	    (>::bool                        x y . z)
	    (2<=::bool                      x y)
	    (<=::bool                       x y . z)
	    (2>=::bool                      x y)
	    (>=::bool                       x y . z)
	    (zero?::bool                    x)
	    (positive?::bool                x)
	    (negative?::bool                x)
	    (max                            x . y)
	    (min                            x . y)
	    (2+                             x y)
	    (+                              . x)
	    (2*                             x y)
	    (*                              . x)
	    (2-                             x y)
	    (-                              x . y)
	    (2/                             x y)
	    (/                              x . y)
	    (abs                            x)
	    (floor                          x)
	    (ceiling                        x)
	    (truncate                       x)
	    (round                          x)
	    (exp::double                    x) 
	    (log::double                    x) 
	    (sin::double                    x) 
	    (cos::double                    x) 
	    (tan::double                    x) 
	    (asin::double                   x) 
	    (acos::double                   x) 
	    (atan::double                   x . y) 
	    (sqrt::double                   x) 
	    (expt                           x y)
	    (inline exact->inexact          z)
	    (inline inexact->exact          z)
	    (number->string::string         x . radix)
	    (string->number                 x . radix))

   (pragma  (2= side-effect-free)
	    (= side-effect-free)
	    (2< side-effect-free)
	    (< side-effect-free)
	    (2> side-effect-free)
	    (> side-effect-free)
	    (2<= side-effect-free)
	    (<= side-effect-free)
	    (2>= side-effect-free)
	    (>= side-effect-free)
	    (zero? side-effect-free)
	    (positive? side-effect-free)
	    (negative? side-effect-free)
	    (max side-effect-free)
	    (min side-effect-free)
	    (2+ side-effect-free)
	    (+ side-effect-free)
	    (2* side-effect-free)
	    (* side-effect-free)
	    (2/ side-effect-free)
	    (/ side-effect-free)
	    (2- side-effect-free)
	    (- side-effect-free)
	    (abs side-effect-free)
	    (floor side-effect-free)
	    (ceiling side-effect-free)
	    (truncate side-effect-free)
	    (round side-effect-free)
	    (exp side-effect-free)
	    (log side-effect-free)
	    (sin side-effect-free)
	    (cos side-effect-free)
	    (tan side-effect-free)
	    (asin side-effect-free)
	    (acos side-effect-free)
	    (atan side-effect-free)
	    (sqrt side-effect-free)
	    (expt side-effect-free)
	    (exact->inexact side-effect-free)
	    (inexact->exact side-effect-free)
	    (number->string side-effect-free)
	    (string->number side-effect-free)))
		  

;*---------------------------------------------------------------------*/
;*    number? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (number? obj)
   (if (fixnum? obj)
       #t
       (flonum? obj)))

;*---------------------------------------------------------------------*/
;*    exact? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exact? z)
   (integer? z))

;*---------------------------------------------------------------------*/
;*    inexact? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (inexact? z)
   (flonum? z))

;*---------------------------------------------------------------------*/
;*    complex? ...                                                     */
;*---------------------------------------------------------------------*/
(define (complex? x)
   (number? x))

;*---------------------------------------------------------------------*/
;*    rational? ...                                                    */
;*---------------------------------------------------------------------*/
(define (rational? x)
   (real? x))

;*---------------------------------------------------------------------*/
;*    flonum->fixnum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (flonum->fixnum x)
   (c-flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    fixnum->flonum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->flonum x)
   (c-fixnum->flonum x))
		       
;*---------------------------------------------------------------------*/
;*    2= ...                                                           */
;*---------------------------------------------------------------------*/
(define (2= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (=fx x y))
	  ((flonum? y)
	   (=fl (fixnum->flonum x) y))
	  (else
	   (error "=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (=fl x y))
	  ((fixnum? y)
	   (=fl x (fixnum->flonum y)))
	  (else
	   (error "=" "not a number" y))))
      (else
       (error "=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    = ...                                                            */
;*---------------------------------------------------------------------*/
(define (= x y . z)
   (define (=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2= x (car z))
		(=-list x (cdr z)))
	       (else #f)))
   (and (2= x y)
	(=-list y z)))

;*---------------------------------------------------------------------*/
;*    2< ...                                                           */
;*---------------------------------------------------------------------*/
(define (2< x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (<fx x y))
	  ((flonum? y)
	   (<fl (fixnum->flonum x) y))
	  (else
	   (error "<" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (<fl x y))
	  ((fixnum? y)
	   (<fl x (fixnum->flonum y)))
	  (else
	   (error "<" "not a number" y))))
      (else
       (error "<" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    < ...                                                            */
;*---------------------------------------------------------------------*/
(define (< x y . z)
   (define (<-list x z)
	    (cond
	       ((null? z) #t)
	       ((2< x (car z))
		(<-list (car z) (cdr z)))
	       (else #f)))
   (and (2< x y)
	(<-list y z)))

   
;*---------------------------------------------------------------------*/
;*    2> ...                                                           */
;*---------------------------------------------------------------------*/
(define (2> x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (>fx x y))
	  ((flonum? y)
	   (>fl (fixnum->flonum x) y))
	  (else
	   (error ">" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (>fl x y))
	  ((fixnum? y)
	   (>fl x (fixnum->flonum y)))
	  (else
	   (error ">" "not a number" y))))
      (else
       (error ">" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    > ...                                                            */
;*---------------------------------------------------------------------*/
(define (> x y . z)
   (define (>-list x z)
	    (cond
	       ((null? z) #t)
	       ((2> x (car z))
		(>-list (car z) (cdr z)))
	       (else #f)))
   (and (2> x y)
	(>-list y z)))
 
;*---------------------------------------------------------------------*/
;*    2<= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2<= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (<=fx x y))
	  ((flonum? y)
	   (<=fl (fixnum->flonum x) y))
	  (else
	   (error "<=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (<=fl x y))
	  ((fixnum? y)
	   (<=fl x (fixnum->flonum y)))
	  (else
	   (error "<=" "not a number" y))))
      (else
       (error "<=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    <= ...                                                           */
;*---------------------------------------------------------------------*/
(define (<= x y . z)
   (define (<=-list x z)
      (cond
	 ((null? z) #t)
	 ((2<= x (car z))
	  (<=-list (car z) (cdr z)))
	 (else #f)))
   (and (2<= x y)
	(<=-list y z)))

;*---------------------------------------------------------------------*/
;*    2>= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2>= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (>=fx x y))
	  ((flonum? y)
	   (>=fl (fixnum->flonum x) y))
	  (else
	   (error ">=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (>=fl x y))
	  ((fixnum? y)
	   (>=fl x (fixnum->flonum y)))
	  (else
	   (error ">=" "not a number" y))))
      (else
       (error ">=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    >= ...                                                           */
;*---------------------------------------------------------------------*/
(define (>= x y . z)
   (define (>=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2>= x (car z))
		(>=-list (car z) (cdr z)))
	       (else #f)))
   (and (2>= x y)
	(>=-list y z)))

;*---------------------------------------------------------------------*/
;*    zero? ...                                                        */
;*---------------------------------------------------------------------*/
(define (zero? x)
   (cond
      ((fixnum? x)
       (zerofx? x))
      ((flonum? x)
       (zerofl? x))
      (else
       (error "zero" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    positive? ...                                                    */
;*---------------------------------------------------------------------*/
(define (positive? x)
   (cond
      ((fixnum? x)
       (positivefx? x))
      ((flonum? x)
       (positivefl? x))
      (else
       (error "positive" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    negative? ...                                                    */
;*---------------------------------------------------------------------*/
(define (negative? x)
   (cond
      ((fixnum? x)
       (negativefx? x))
      ((flonum? x)
       (negativefl? x))
      (else
       (error "negative" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    max ...                                                          */
;*---------------------------------------------------------------------*/
(define (max x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (> x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    min ...                                                          */
;*---------------------------------------------------------------------*/
(define (min x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (< x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    2+ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2+ x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (+fx x y))
	  ((flonum? y)
	   (+fl (fixnum->flonum x) y))
	  (else
	   (error "+" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (+fl x y))
	  ((fixnum? y)
	   (+fl x (fixnum->flonum y)))
	  (else
	   (error "+" "not a number" y))))
      (else
       (error "+" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    + ...                                                            */
;*---------------------------------------------------------------------*/
(define (+  . x)
   (let loop ((sum 0)
	      (x x))
      (if (pair? x)
	  (loop (2+ sum (car x))
		(cdr x))
	  sum)))

;*---------------------------------------------------------------------*/
;*    2* ...                                                           */
;*---------------------------------------------------------------------*/
(define (2* x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (*fx x y))
	  ((flonum? y)
	   (*fl (fixnum->flonum x) y))
	  (else
	   (error "*" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (*fl x y))
	  ((fixnum? y)
	   (*fl x (fixnum->flonum y)))
	  (else
	   (error "*" "not a number" y))))
      (else
       (error "*" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    * ...                                                            */
;*---------------------------------------------------------------------*/
(define (*  . x)
   (let loop ((product 1)
	      (x x))
      (if (pair? x)
	  (loop (2* product (car x)) (cdr x))
	  product)))

;*---------------------------------------------------------------------*/
;*    2- ...                                                           */
;*---------------------------------------------------------------------*/
(define (2- x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (-fx x y))
	  ((flonum? y)
	   (-fl (fixnum->flonum x) y))
	  (else
	   (error "-" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (-fl x y))
	  ((fixnum? y)
	   (-fl x (fixnum->flonum y)))
	  (else
	   (error "-" "not a number" y))))
      (else
       (error "-" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    - ...                                                            */
;*---------------------------------------------------------------------*/
(define (- x . y)
    (if (pair? y)
	(let loop ((result (2- x (car y)))
		   (args (cdr y)))
	   (if (pair? args)
	       (loop (2- result (car args)) (cdr args))
	       result))
	(2- 0 x)))

;*---------------------------------------------------------------------*/
;*    2/ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2/ x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (if (=fx (remainder x y) 0)
	       (/fx x y)
	       (/fl (fixnum->flonum x) (fixnum->flonum y))))
	  ((flonum? y)
	   (/fl (fixnum->flonum x) y))
	  (else
	   (error "/" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (/fl x y))
	  ((fixnum? y)
	   (/fl x (fixnum->flonum y)))
	  (else
	   (error "/" "not a number" y))))
      (else
       (error "/" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    / ...                                                            */
;*---------------------------------------------------------------------*/
(define (/ x . y)
    (if (pair? y)
	(let loop ((result (2/ x (car y)))
		   (z (cdr y)))
	     (if (pair? z)
		 (loop (2/ result (car z))
		       (cdr z))
		 result))
	(2/ 1 x)))

;*---------------------------------------------------------------------*/
;*    abs ...                                                          */
;*---------------------------------------------------------------------*/
(define (abs x)
   (cond
      ((fixnum? x)
       (absfx x))
      ((flonum? x)
       (absfl x))
      (else
       (error "abs" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    floor ...                                                        */
;*---------------------------------------------------------------------*/
(define (floor x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (floorfl x))
      (else
       (error "floor" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    ceiling ...                                                      */
;*---------------------------------------------------------------------*/
(define (ceiling x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (ceilingfl x))
      (else
       (error "ceiling" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    truncate ...                                                     */
;*---------------------------------------------------------------------*/
(define (truncate x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (truncatefl x))
      (else
       (error "truncate" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    round ...                                                        */
;*---------------------------------------------------------------------*/
(define (round x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (roundfl x))
      (else
       (error "round" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    exp ...                                                          */
;*---------------------------------------------------------------------*/
(define (exp x)
   (cond
      ((fixnum? x)
       (expfl (fixnum->flonum x)))
      ((flonum? x)
       (expfl x))
      (else
       (error "exp" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    log ...                                                          */
;*---------------------------------------------------------------------*/
(define (log x)
   (cond
      ((fixnum? x)
       (logfl (fixnum->flonum x)))
      ((flonum? x)
       (logfl x))
      (else
       (error "log" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    sin ...                                                          */
;*---------------------------------------------------------------------*/
(define (sin x)
   (cond
      ((fixnum? x)
       (sinfl (fixnum->flonum x)))
      ((flonum? x)
       (sinfl x))
      (else
       (error "sin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    cos ...                                                          */
;*---------------------------------------------------------------------*/
(define (cos x)
   (cond
      ((fixnum? x)
       (cosfl (fixnum->flonum x)))
      ((flonum? x)
       (cosfl x))
      (else
       (error "cos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    tan ...                                                          */
;*---------------------------------------------------------------------*/
(define (tan x)
   (cond
      ((fixnum? x)
       (tanfl (fixnum->flonum x)))
      ((flonum? x)
       (tanfl x))
      (else
       (error "tan" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    asin ...                                                         */
;*---------------------------------------------------------------------*/
(define (asin x)
   (cond
      ((fixnum? x)
       (asinfl (fixnum->flonum x)))
      ((flonum? x)
       (asinfl x))
      (else
       (error "asin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    acos ...                                                         */
;*---------------------------------------------------------------------*/
(define (acos x)
   (cond
      ((fixnum? x)
       (acosfl (fixnum->flonum x)))
      ((flonum? x)
       (acosfl x))
      (else
       (error "acos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    atan ...                                                         */
;*---------------------------------------------------------------------*/
(define (atan x . y)
   (let ((y (if (pair? y)
		(let ((y (car y)))
		   (cond
		      ((fixnum? y)
		       (fixnum->flonum y))
		      ((flonum? y)
		       y)
		      (else
		       (error "atan" "not a number" y))))
		#f)))
      (define (do-atanfl x) 
	 (if (number? y)
	     (atanfl x y)
	     (atanfl x)))
      (cond
	 ((fixnum? x)
	  (do-atanfl (fixnum->flonum x)))
	 ((flonum? x)
	  (do-atanfl x))
	 (else
	  (error "atan" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    sqrt ...                                                         */
;*---------------------------------------------------------------------*/
(define (sqrt x)
   (cond
      ((fixnum? x)
       (sqrtfl (fixnum->flonum x)))
      ((flonum? x)
       (sqrtfl x))
      (else
       (error "sqrt" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    expt ...                                                         */
;*---------------------------------------------------------------------*/
(define (expt x y)
   (if (and (flonum? x) (flonum? y) (=fl x 0.0) (=fl y 0.0))
       1.0
       (cond
	  ((and (fixnum? x)
		(fixnum? y))
	   (flonum->fixnum (exptfl (fixnum->flonum x)  (fixnum->flonum y))))
	  ((fixnum? x)
	   (cond
	      ((flonum? y)
	       (exptfl (fixnum->flonum x) y))
	      (else
	       (error "expt" "not a number" y))))
	  ((flonum? x)
	   (cond
	      ((flonum? y)
	       (exptfl x y))
	      ((fixnum? y)
	       (exptfl x (fixnum->flonum y)))
	      (else
	       (error "expt" "not a number" y))))
	  (else
	   (error "expt" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    exact->inexact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (exact->inexact z)
   (if (exact? z)
       (fixnum->flonum z)
       z))

;*---------------------------------------------------------------------*/
;*    inexact->exact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (inexact->exact z)
   (if (inexact? z)
       (flonum->fixnum z)
       z))
 
;*---------------------------------------------------------------------*/
;*    number->string ...                                               */
;*---------------------------------------------------------------------*/
(define (number->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (cond
      ((fixnum? x)
       (integer->string x radix))
      ((flonum? x)
       (real->string x))
      (else
       (error "number->string" "Argument not a number" x))))

;*---------------------------------------------------------------------*/
;*    string->number ...                                               */
;*---------------------------------------------------------------------*/
(define (string->number x . radix)
   (define (integer-string? x)
      (let loop ((i (-fx (string-length x) 1)))
	 (cond
	    ((=fx i -1)
	     #t)
	    ((char=? (string-ref x i) #\-)
	     (=fx i 0))
	    ((and (char>=? (string-ref x i) #\0)
		  (char<=? (string-ref x i) #\9))
	     (loop (-fx i 1)))
	    ((and (char>=? (string-ref x i) #\a)
		  (char<=? (string-ref x i) #\f))
	     (loop (-fx i 1)))
	    ((and (char>=? (string-ref x i) #\A)
		  (char<=? (string-ref x i) #\F))
	     (loop (-fx i 1)))
	    (else
	     #f))))
   (if (integer-string? x)
       (apply string->integer (cons x radix))
       (apply string->real (cons x radix))))

