;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9c/Eval/expd-bool.scm       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:12:21 1993                          */
;*    Last change :  Tue Aug  5 11:13:10 1997 (serrano)                */
;*                                                                     */
;*    Les expanseurs des formes booleenes.                             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_bool
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__progn                   "Eval/progn.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (expand-or   <expression>)  
	    (expand-and  <expression>)
	    (expand-cond <expression>)))

;*---------------------------------------------------------------------*/
;*    get-new-test-name ...                                            */
;*---------------------------------------------------------------------*/
(define (get-new-test-name string)
   (gensym (string-append "_" string "test_")))

;*---------------------------------------------------------------------*/
;*    expand-or ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-or exp)
   (let ((res (let loop ((sor (cdr exp)))
		 (cond
		    ((null? sor)
		     #f)
		    ((not (pair? sor))
		     (error "or" "Illegal form" exp))
		    ((null? (cdr sor))
		     (car sor))
		    (else
		     (let ((test (get-new-test-name "or")))
			`(let ((,test ,(car sor)))
			    (if ,test ,test ,(loop (cdr sor))))))))))
      (replace! exp res)))

;*---------------------------------------------------------------------*/
;*    expand-and ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-and exp)
   (let ((res (let loop ((sand (cdr exp)))
		 (cond
		    ((null? sand)
		     #t)
		    ((not (pair? sand))
		     (error "and" "Illegal form" exp))
		    ((null? (cdr sand))
		     (car sand))
		    (else
		     (let ((test (get-new-test-name "and")))
			`(let ((,test ,(car sand)))
			    (if ,test ,(loop (cdr sand)) #f))))))))
      (replace! exp res)))

;*---------------------------------------------------------------------*/
;*    expand-cond ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-cond exp)
   (let ((res (let* ((clauses  (cdr exp))
		     (clause1  (if (pair? clauses)
				   (car clauses)
				   '()))
		     (clause2+ (if (pair? clause1)
				   (cdr clauses)
				   #f)))
		 (cond
		    ((null? clause1)
		     '#f)
		    ((or (not (pair? clause1)) (equal? clause1 '(else)))
		     (error "cond-clause" "Illegal form" exp))
		    ((null? (cdr clause1))
		     `(or ,(car clause1) (cond ,@clause2+)))
		    ((and (eq? (cadr clause1) '=>) (=fx (length clause1) 3))
		     `(let ((test-result ,(car clause1))
			    (thunk2 (lambda () ,(caddr clause1)))
			    (thunk3 (lambda () (cond ,@clause2+))))
			 (if test-result ((thunk2) test-result) (thunk3))))
		    ((eq? (car clause1) 'else)
		     (normalize-progn (cdr clause1)))
		    (else `(if ,(car clause1)
			       ,(normalize-progn (cdr clause1))
			       (cond ,@clause2+)))))))
      (replace! exp res)))














