/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/init-obj.c              */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:00:08 1992                          */
/*    Last change :  Fri Mar 20 09:11:42 1998 (serrano)                */
/*                                                                     */
/*    On initialise les objects vitaux                                 */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo1.9c.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t  an_object, a_pair;

obj_t  quote;
obj_t *c_allocated_char;
obj_t  _exit_value_;

/*---------------------------------------------------------------------*/
/*    Importatations                                                   */
/*---------------------------------------------------------------------*/
extern obj_t string_to_obj();
extern obj_t string_to_symbol();

extern void init_symbol_table();
extern void init_keyword_table();
extern void init_io();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
void init_objects()
{
   /* l'initialisation des ports d'entree/sortie */
   init_io();

   /* l'initialisation des symbols */
   init_symbol_table();

   /* the dsssl keywords initialization */
   init_keyword_table();

   /* l'initialisation du symbol QUOTE (voir apply.c) */
   quote = string_to_symbol( "QUOTE" );
}
