;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/struct.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 09:42:44 1992                          */
;*    Last change :  Fri Dec 30 11:59:38 1994 (serrano)                */
;*                                                                     */
;*    On test le fonctionnement des structures                         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module struct
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-struct)))

;*---------------------------------------------------------------------*/
;*    La structure ...                                                 */
;*---------------------------------------------------------------------*/
(define-struct structure x lambda y res)
(define-struct point x y z)

;*---------------------------------------------------------------------*/
;*    test-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-struct)
   (test-module "struct" "struct.scm" #f)
   (test "struct" (let ((s (make-structure '())))
		     (if (not (struct? s))
			 #f)
		     (structure-lambda-set! s (lambda (x y) (+ x y)))
		     (structure-x-set! s 1)
		     (structure-y-set! s 2)
		     (structure-res-set! s ((structure-lambda s)
					    (structure-x s)
					    (structure-y s)))
		     (structure-res s))
	 3)
   (let ((p1 (point 1 2 3))
	 (p2 (point 4 5 6)))
      (test "update!" (begin
			 (struct-update! p1 p2)
			 p1)
	    p2)))


