;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Type/tenv.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 11:32:49 1994                          */
;*    Last change :  Fri Feb  6 16:50:50 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Type environment manipulation                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_env

   (include "Tools/trace.sch")
   
   (import  tools_shape
	    tools_error
	    ast_ident
	    engine_param
	    module_module
	    type_type
	    type_tools
	    type_cache)

   (static  (bind-type!::type         ::symbol ::bool)
	    (uninitialized-types))

   (export  (initialize-Tenv!)
	    (set-Tenv!                <Tenv>)
	    (get-Tenv)
	    (find-type::type          ::symbol)
	    (use-type!::type          ::symbol)
	    (use-foreign-type!::type  ::symbol)
	    (type-exists?::bool       ::symbol)
	    (declare-type!::type      ::symbol ::bstring ::symbol)
	    (declare-subtype!::type   ::symbol ::bstring symbol* ::symbol)
	    (declare-aliastype!::type ::symbol ::bstring ::symbol ::type)
	    (for-each-type!           ::procedure)
	    (check-types)
	    (sub-type?::bool          ::type ::type)))

;*---------------------------------------------------------------------*/
;*    *Tenv* ...                                                       */
;*    -------------------------------------------------------------    */
;*    The Global environment (for global variable definitions).        */
;*---------------------------------------------------------------------*/
(define *Tenv* 'the-global-environment)

;*---------------------------------------------------------------------*/
;*    get-hash-number ...                                              */
;*---------------------------------------------------------------------*/
(define (get-hash-number o)
   (string->0..2^x-1 (symbol->string o) 10))

;*---------------------------------------------------------------------*/
;*    set-Tenv! ...                                                    */
;*---------------------------------------------------------------------*/
(define (set-Tenv! Tenv)
   (set! *Tenv* Tenv)
   (struct-set! *Tenv* 2 get-hash-number)
   (struct-set! *Tenv* 3 type-id)
   (struct-set! *Tenv* 5 eq?))
		 
;*---------------------------------------------------------------------*/
;*    get-Tenv ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-Tenv)
   (struct-set! *Tenv* 2 'get-hash-number)
   (struct-set! *Tenv* 3 'type-id)
   (struct-set! *Tenv* 5 'eq?)
   *Tenv*)

;*---------------------------------------------------------------------*/
;*    initialize-Tenv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Tenv!)
   ;; the global environment
   (set! *Tenv* (make-hash-table 1024 get-hash-number type-id eq? 256)))

;*---------------------------------------------------------------------*/
;*    find-type ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-type::type id::symbol)
   (let ((type (get-hash id *Tenv*)))
      (if (not (type? type))
	  (error "find-type" "Can't find type" id)
	  type)))

;*---------------------------------------------------------------------*/
;*    type-exists? ...                                                 */
;*    -------------------------------------------------------------    */
;*    Returns #t if the type exists _and_ is initialized.              */
;*---------------------------------------------------------------------*/
(define (type-exists?::bool id::symbol)
   (let ((type (get-hash id *Tenv*)))
      (if (not (type? type))
	  #f
	  (type-init? type))))

;*---------------------------------------------------------------------*/
;*    bind-type! ...                                                   */
;*---------------------------------------------------------------------*/
(define (bind-type!::type id::symbol init?::bool)
   (let ((type (get-hash id *Tenv*)))
      (if (type? type)
	  (if (and (not *lib-mode*) (type-init? type))
	      (user-error "bind-type!" "Type redefinition" (shape type))
	      (begin
		 ;; the type has already been allocated, we mark it
		 ;; has initialized.
		 (if init? (type-init?-set! type #t))
		 ;; and we return it.
		 type))
	  (let ((new (instantiate::type (id id) (init? init?))))
	     (put-hash! new *Tenv*)
	     new))))

;*---------------------------------------------------------------------*/
;*    use-type! ...                                                    */
;*---------------------------------------------------------------------*/
(define (use-type!::type id::symbol)
   (trace (ast 2) "~~~ use-type!: " id #\Newline)
   (let ((type (get-hash id *Tenv*)))
      (cond
	 ((type? type)
	  type)
	 (*types-already-checked?*
	  (error "use-type!" "Can't find type" id))
	 (else
	  (bind-type! id #f)))))

;*---------------------------------------------------------------------*/
;*    use-foreign-type! ...                                            */
;*    -------------------------------------------------------------    */
;*    I have changed the syntax for the foreign declaration. In order  */
;*    to be consisten now, extern clauses have to be written using     */
;*    the :: notation (e.g. (print::int (::string ::int) "printf")).   */
;*    Since I also want a backward compatibility Bigloo accepts the    */
;*    two syntaxes. This function implement the compatibility.         */
;*---------------------------------------------------------------------*/
(define (use-foreign-type!::type id::symbol)
   (trace (ast 2) "~~~ use-foreign-type!: " id #\Newline)
   (let ((tid (parse-id id)))
      ;; parse-id calls  use-type! so, here we have to call use-type!
      ;; if and only if parse-id did do it with a real type.
      ;; That is, if the cdr of the result of parse-id is not
      ;; the default type.
      (if (eq? (cdr tid) (get-default-type))
	  ;; This works only because the default type is not a legal type
	  ;; that one can use in a foreign clause.
	  (use-type! (car tid))
	  (cdr tid))))

;*---------------------------------------------------------------------*/
;*    declare-type! ...                                                */
;*---------------------------------------------------------------------*/
(define (declare-type!::type id::symbol name::bstring class::symbol)
   (trace (ast 2) "~~~ declare-type!: " id #\Newline)
   (if (not (memq class '(bigloo C _)))
       (user-error "declare-type!"
		   "Illegal type class"
		   class)
       (let ((type (bind-type! id #t)))
	  (type-name-set!   type name)
	  (type-$-set!      type ($-in-name? name))
	  (type-class-set!  type class)
	  type)))
 
;*---------------------------------------------------------------------*/
;*    declare-subtype! ...                                             */
;*    -------------------------------------------------------------    */
;*    Subtype inherit from coercion of their parents.                  */
;*---------------------------------------------------------------------*/
(define (declare-subtype!::type id::symbol name::bstring parents class::symbol)
   (trace (ast 2) "~~~ declare-subtype!: " id #\Newline)
   [assert (parents) (list? parents)]
   (let ((type    (bind-type! id #t))
	 (parents (map find-type parents)))
      (type-name-set!    type name)
      (type-$-set!       type ($-in-name? name))
      (type-class-set!   type class)
      (type-parents-set! type parents)
      type))

;*---------------------------------------------------------------------*/
;*    declare-aliastype! ...                                           */
;*---------------------------------------------------------------------*/
(define (declare-aliastype! id name class::symbol alias::type)
   (trace (ast 2) "~~~ declare-aliastype!: " id #\Newline)
   (let ((type (declare-type! id name class)))
      (type-alias-set! type alias)
      type)) 

;*---------------------------------------------------------------------*/
;*    for-each-type! ...                                               */
;*---------------------------------------------------------------------*/
(define (for-each-type! proc)
   (for-each-hash proc *Tenv*))

;*---------------------------------------------------------------------*/
;*    uninitialized-types ...                                          */
;*    -------------------------------------------------------------    */
;*    We build the list of the unitialized types.                      */
;*---------------------------------------------------------------------*/
(define (uninitialized-types)
   (let ((uninit '()))
      (for-each-type! (lambda (t)
			 (if (not (type-init? t))
			     (set! uninit (cons t uninit)))))
      uninit))

;*---------------------------------------------------------------------*/
;*    *types-already-checked?* ...                                     */
;*---------------------------------------------------------------------*/
(define *types-already-checked?* #f)

;*---------------------------------------------------------------------*/
;*    check-types ...                                                  */
;*    -------------------------------------------------------------    */
;*    We check that all types are initialized.                         */
;*    -------------------------------------------------------------    */
;*    After this function is called, `use-type' does not tolerate the  */
;*    usage of undefined types (this is implemented using the          */
;*    `types-already-checked?*' variable).                             */
;*---------------------------------------------------------------------*/
(define (check-types)
   (let ((ut (uninitialized-types)))
      (if (pair? ut)
	  (error *module*
		 "These types are used but not defined"
		 (shape ut))
	  (set! *types-already-checked?* #t))))

;*---------------------------------------------------------------------*/
;*    sub-type? ...                                                    */
;*    -------------------------------------------------------------    */
;*    Is a type a subtype of `obj' ?                                   */
;*---------------------------------------------------------------------*/
(define (sub-type? minor major)
   (cond
      ((eq? minor major)
       #t)
      ((memq major (type-parents minor))
       #t)
      (else
       #f)))
