;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Tools/location.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 10:00:44 1996                          */
;*    Last change :  Mon Dec 22 08:10:04 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The location managment                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module ...                                                   */
;*---------------------------------------------------------------------*/
(module tools_location
   (include "Tools/location.sch")
   (export  (find-location                <s-exp>)
	    (find-location/loc            <s-exp> ::obj)
	    (location-full-fname::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    find-location ...                                                */
;*---------------------------------------------------------------------*/
(define (find-location exp)
   (cond
      ((epair? exp)
       ;; easy the location has been directly produced by the reader.
       (let ((reader-location (cer exp)))
          (match-case reader-location
             ((at ?fname ?pos)
              (location fname pos))
             (else
              #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    find-location/loc ...                                            */
;*---------------------------------------------------------------------*/
(define (find-location/loc exp loc)
   (let ((new-loc (find-location exp)))
      (if (location? new-loc)
	  new-loc
	  loc)))

;*---------------------------------------------------------------------*/
;*    location-full-fname ...                                          */
;*---------------------------------------------------------------------*/
(define (location-full-fname loc)
   (let ((fname (location-fname loc))
         (pwd   (let ((vpwd (getenv "PWD")))
                   (if (string? vpwd)
                       vpwd
                       (pwd)))))
      (string-append pwd "/" fname)))

