;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Object/slots.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 18 12:48:07 1996                          */
;*    Last change :  Mon Sep 30 09:36:46 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We build the class slots                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_slots
   (include "Object/class.sch")
   (import  tools_error
	    type_type
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    engine_param)
   (export  (make-class-slots ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    ensure-type-defined! ...                                         */
;*---------------------------------------------------------------------*/
(define (ensure-type-defined! type::type src)
   (if (not (type-init? type))
       (user-error "Can't find type definition" (type-id type) src)))

;*---------------------------------------------------------------------*/
;*    make-class-slots ...                                             */
;*---------------------------------------------------------------------*/
(define (make-class-slots slots super src)
   (define (find-default-attr attr)
      (if (not (pair? attr))
	  '(#f . #unspecified)
	  (match-case (car attr)
	     ((default ?value)
	      (cons #t value))
	     (else
	      (find-default-attr (cdr attr))))))
   (define (find-assert-attr attr)
      (if (not (pair? attr))
	  #f
	  (match-case (car attr)
	     ((assert ((? symbol?)) ?value)
	      (set-car! (car attr) 'lambda)
	      (car attr))
	     (else
	      (find-assert-attr (cdr attr))))))
   (let loop ((slots slots)
	      (res   (cond
			((not (type? super))
			 '())
			((not (class? super))
			 '())
			(else
			 ;; take care to the double reverse. Here we can't
			 ;; do in in-place reverse otherwise will be destroying
			 ;; super classes fields. This reverse allocates
			 ;; a fresh slots list.
			 (reverse (class-slots super))))))
      (if (null? slots)
	  ;; here is the second reverse (I'm wondering if tail recursion
	  ;; is more important that those two reverse ?).
	  (reverse! res)
	  (let ((s (car slots)))
	     (match-case s
		((* (id ?slot-id) . ?attr)
		 (let ((id      (symbol-append (car slot-id) '-len))
		       (default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #t
				      #f
				      (memq 'read-only attr)
				      (car default)
				      (cdr default)
				      a-exp)
				(cons 
				 (slot id
				       (scheme-symbol->c-string id)
				       *long*
				       #f
				       #unspecified
				       #f
				       #t
				       #t
				       #f
				       #unspecified
				       #f)
				 res)))))
		((+ ?len (id ?slot-id) . ?attr)
		 (let ((id      (symbol-append (car slot-id) '-len))
		       (default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #t
				      len
				      #f
				      #f
				      (memq 'read-only attr)
				      (car default)
				      (cdr default)
				      a-exp)
				res))))
		(((id ?slot-id) . ?attr)
		 (let ((default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #f
				      #f
				      (memq 'read-only attr)
				      (car default)
				      (cdr default)
				      a-exp)
				res))))
		((id ?slot-id)
		 (let ((type (if (eq? (cdr slot-id) *_*)
				 *obj*
				 (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #f
				      #f
				      #f
				      #f
				      #unspecified
				      #f)
				res))))
		(else
		 (user-error "Parse error"
			     "Unknown class slot type"
			     s
			     '())))))))

;*---------------------------------------------------------------------*/
;*    scheme-symbol->c-string ...                                      */
;*---------------------------------------------------------------------*/
(define (scheme-symbol->c-string symbol)
   (if *case-sensitive*
       (id->name symbol)
       (string-downcase (id->name symbol))))


