;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/class.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 10:52:20 1996                          */
;*    Last change :  Wed Feb 11 10:47:19 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The class clause handling                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_class
   (include "Ast/unit.sch"
	    "Object/class.sch"
	    "Tools/trace.sch")
   (import  module_module
	    module_impuse
	    engine_param
	    tools_shape
	    type_type
	    type_env
	    ast_ident
	    ast_var
	    ast_env
	    object_class
	    object_access)
   (export  (declare-class!      cdef mod::symbol imp::symbol fin::bool ::obj)
	    (declare-wide-class! cdef mod::symbol imp::symbol ::obj)
	    (get-class-hash      class-id::symbol fields)
	    (class-finalizer)))

;*---------------------------------------------------------------------*/
;*    declare-class! ...                                               */
;*---------------------------------------------------------------------*/
(define (declare-class! class-def module import final? src-def)
   (trace (ast 2) "declare-class!: " src-def #\Newline)
   ;; We create the class holder
   ;; and we create a type for this class
   (let* ((class-var (car class-def))
	  (class-id  (id-of-id class-var))
	  (holder    (if (or (eq? import 'import) (eq? import 'use))
			 (import-parser module class-id)
			 (begin
			    (produce-module-clause! `(,import ,class-id))
			    (find-global class-id module))))
	  (type      (declare-class-type! class-def holder #f final? src-def))
	  (domestic? (memq import '(export static))))
      ;; type can be something else than a class if an error has been found
      (if (class? type)
	  (begin
	     ;; then, we declare the class when it is a class definition
	     (if domestic? (make-add-class! holder type src-def))
	     ;; now we build the class' accessors
	     (set! *class-accesses*
		   (cons (cons type
			       (delay (make-class-accesses! class-def
							    type
							    src-def
							    domestic?)))
			 *class-accesses*))
	     type)
	  #unspecified)))

;*---------------------------------------------------------------------*/
;*    declare-wide-class! ...                                          */
;*---------------------------------------------------------------------*/
(define (declare-wide-class! class-def module import src-def)
   ;; We create the class holder
   ;; and we create a type for this class
   (let* ((class-var (car class-def))
	  (class-id  (id-of-id class-var))
	  (holder    (if (or (eq? import 'import) (eq? import 'use))
			 (import-parser module class-id)
			 (begin
			    (produce-module-clause! `(,import ,class-id))
			    (find-global class-id module))))
	  (type      (declare-class-type! class-def
					  holder
					  (gensym 'widening)
					  #f
					  src-def))
	  (domestic? (memq import '(export static))))
      ;; type can be something else than a class is an error has been found
      (if (class? type)
	  (begin
	     ;; then, we declare the class when it is a class definition
	     (if domestic? (make-add-class! holder type src-def))
	     ;; now we build the class' accessors
	     (set! *class-accesses*
		   (cons (cons type
			       (delay (make-wide-class-accesses! class-def
								 type
								 src-def
								 domestic?)))
			 *class-accesses*))))))

;*---------------------------------------------------------------------*/
;*    *class-accesses* ...                                             */
;*---------------------------------------------------------------------*/
(define *class-accesses* '())

;*---------------------------------------------------------------------*/
;*    *declared-classes* ...                                           */
;*---------------------------------------------------------------------*/
(define *declared-classes* '())

;*---------------------------------------------------------------------*/
;*    make-add-class! ...                                              */
;*---------------------------------------------------------------------*/
(define (make-add-class! holder class src-def)
   (let* ((super          (class-its-super class))
	  (holder-id      (global-id holder))
	  (class-id       (type-id class))
	  (class-module   (global-module holder))
	  (class-alloc-id (symbol-append 'allocate- class-id))
	  (class-alloc    `(@ ,class-alloc-id ,class-module))
	  (hash           (get-class-hash class-id (cddr src-def))))
      (let ((decl (if (not (class? super))
		      `(define ,holder-id
			  ((@ add-class! __object) ',class-id
						   #f
						   ,class-alloc
						   ,hash
						   ,(make-class-fields
						     class-id
						     (cddr src-def))))
		      (let* ((sholder        (class-holder super))
			     (sholder-id     (global-id sholder))
			     (sholder-module (global-module sholder)))
			 `(define ,holder-id
			     ((@ add-class! __object) ',class-id
						      (@ ,sholder-id
							 ,sholder-module)
						      ,class-alloc
						      ,hash
						      ,(make-class-fields
							class-id
							(cddr src-def))))))))
	 (set! *declared-classes* (cons decl *declared-classes*)))))

;*---------------------------------------------------------------------*/
;*    get-hash-class ...                                               */
;*---------------------------------------------------------------------*/
(define (get-class-hash class-id fields)
   (let loop ((fields fields)
	      (hash (string->0..2^x-1 (symbol->string class-id) 16)))
      (if (null? fields)
	  hash
	  (let ((field (car fields)))
	     (match-case field
		((? symbol?)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (symbol->string field)
				 16))))
		((* (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "* "
				  (symbol->string id))
				 16))))
		((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "+ "
				  (integer->string len)
				  (symbol->string id))
				 16))))
		((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "+ "
				  len
				  (symbol->string id))
				 16))))
		(((and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (symbol->string id)
				 16)))))))))

;*---------------------------------------------------------------------*/
;*    make-class-fields ...                                            */
;*    -------------------------------------------------------------    */
;*    We have not found a better way to do it. We re-parse the class   */
;*    definition (according to module_prototype and object_slots)      */
;*    to produce the correct proper list for the class declaration.    */
;*---------------------------------------------------------------------*/
(define (make-class-fields class-id slot-defs)
   (define (read-only? attr)
      (let loop ((attr attr))
	 (cond
	    ((null? attr)
	     #f)
	    ((memq (car attr) '(read-only))
	     #t)
	    (else
	     (loop (cdr attr))))))
   (define (make-slot-field slot)
      (match-case slot
	 ((? symbol?)
	  (let ((id (fast-id-of-id slot)))
	     `(vector ',slot
		      ,(symbol-append class-id '- id)
		      ,(symbol-append class-id '- id '-set!)
		      #unspecified)))
	 ((* (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      ,(symbol-append class-id '- id '-len))))
	 ((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      (lambda (object) ,len))))
	 ((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      (lambda (object) (pragma::long ,len)))))
	 (((and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      #unspecified)))))
   (if *reflection?*
       `(list ,@(map make-slot-field slot-defs))
       #unspecified))
   
;*---------------------------------------------------------------------*/
;*    class-finalizer ...                                              */
;*---------------------------------------------------------------------*/
(define (class-finalizer)
   (cond
      ((and (null? *declared-classes*) (null? *class-accesses*))
       'void)
      (else
       (list (unit 'object
		   10
		   (append (reverse! *declared-classes*)
			   (force-class-accesses))
		   #t)))))
	     
;*---------------------------------------------------------------------*/
;*    force-class-accesses ...                                         */
;*    -------------------------------------------------------------    */
;*    We should proceed in a top-down order. First, scan the parents   */
;*    classes, then the children. In fact, this is not mandatory. The  */
;*    only thing we have to to is:                                     */
;*       - proceed the non wide classes.                               */
;*       - them, proceed the wide classes.                             */
;*---------------------------------------------------------------------*/
(define (force-class-accesses)
   (letrec ((futurs (reverse! *class-accesses*))
	    (laap   (lambda (accesses pred? done)
		       (let loop ((futur    futurs)
				  (accesses accesses))
			  (if (null? futur)
			      (done accesses)
			      (loop (cdr futur)
				    (let ((class (car (car futur))))
				       (if (pred? class)
					   (let ((new (force (cdr (car futur)))))
					      (if (pair? new)
						  (append new accesses)
						  accesses))
					   accesses))))))))
      (laap '()
	    (lambda (class)
	       (not (wide-class? class)))
	    (lambda (accesses)
	       (laap accesses
		     wide-class?
		     (lambda (accesses) accesses))))))
