;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/checksum.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Thu Aug 21 08:38:45 1997                          */
;*    Last change :  Thu Aug 21 10:49:08 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute checksum for modules in order to be able to check,    */
;*    at module initialization time, that modules are coherent. Only   */
;*    exported and extern values (bindings and classes) are considered */
;*    for checksumming.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_checksum
   
   (include "Ast/unit.sch"
	    "Engine/pass.sch")
   
   (import  engine_param
	    engine_pass
	    tools_error)
   
   (export (clause-checksummer::long clause ::long)
	   (initial-checksum::long   name::symbol)))

;*---------------------------------------------------------------------*/
;*    initial-checksum ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-checksum mname)
   (let ((checksum (bit-xor (string->0..2^x-1 *bigloo-name* 16)
			    (string->0..2^x-1 (symbol->string mname) 16))))
      (if (char? *bigloo-level*)
	  (bit-xor checksum (char->integer *bigloo-level*))
	  checksum)))
   
;*---------------------------------------------------------------------*/
;*    clause-checksummer ...                                           */
;*---------------------------------------------------------------------*/
(define (clause-checksummer clause checksum)
   (define (symbol->number s)
      (string->0..2^x-1 (symbol->string s) 16))
   (define (atom->number checksum clause)
      (cond
	 ((number? clause)
	  (bit-xor checksum clause))
	 ((char? clause)
	  (bit-xor checksum (char->integer clause)))
	 ((cnst? clause)
	  (bit-xor checksum (cnst->integer clause)))
	 ((string? clause)
	  (bit-xor checksum (string->0..2^x-1 clause 16)))
	 ((symbol? clause)
	  (bit-xor checksum (symbol->number clause)))
	 ((pair? clause)
	  (list->number checksum clause))))
   (define (list->number checksum clause)
      (cond
	 ((null? clause)
	  checksum)
	 ((pair? clause)
	  (list->number (atom->number checksum (car clause))
			(cdr clause)))
	 (else
	  (atom->number checksum clause))))
   (list->number checksum clause))
		
