;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.9/Integrate/loc2glo.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 17:29:48 1995                          */
;*    Last change :  Tue Aug  6 12:57:40 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We translate a local function definition into a global one.      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_local->global
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_args
	    module_module
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_glo-def
	    ast_env
	    ast_local
	    integrate_info
	    integrate_node)
   (export  (local->global ::local)
	    (the-global    ::local)))

;*---------------------------------------------------------------------*/
;*    local->global ...                                                */
;*---------------------------------------------------------------------*/
(define (local->global local)
   (trace (integrate 2) (shape local) #\: #\Newline)
   (let* ((global   (the-global local))
	  (kaptured (sfun/Iinfo-kaptured (local-value local)))
	  (add-args (map (lambda (old)
			    (clone-local old
					 (duplicate::svar/Iinfo
					       (local-value old))))
			 kaptured))
	  (old-fun  (local-value local))
	  (new-fun  (duplicate::sfun old-fun
		       (arity (+-arity (sfun-arity old-fun) (length add-args)))
		       (args (append (reverse add-args)
				     (sfun-args old-fun))))))
      ;; we set the result type
      (global-type-set! global (local-type local))
      (for-each (lambda (l)
		   (if (integrate-celled? l)
		       (local-type-set! l *obj*)))
		(sfun-args new-fun))
      (sfun-body-set! new-fun
		      (globalize! (sfun-body old-fun)
				  local
				  (map cons kaptured add-args)))
      (global-value-set! global new-fun)
      global))

;*---------------------------------------------------------------------*/
;*    the-global ...                                                   */
;*---------------------------------------------------------------------*/
(define (the-global local::local)
   (let ((value (local-value local)))
      (if (global? (sfun/Iinfo-global value))
	  (sfun/Iinfo-global value)
	  
	  (let* ((id     (if (global? (find-global (local-id local) *module*))
			     (gensym (local-id local))
			     (local-id local)))
		 (global (def-global-sfun! id
			   ;; we set dummy empty args-id 
			   ;; and dummy empty args because a new-fun
			   ;; will be allocated.
			   '()
			   '()
			   *module*
			   'sfun
			   'a-integrated-body
			   'now
			   #unspecified)))
	     (sfun/Iinfo-global-set! value global)
	     (sfun-side-effect?-set! (global-value global)
				     (sfun-side-effect? value))
	     global))))
