;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Integrate/g.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 14:53:50 1995                          */
;*    Last change :  Fri Jun 28 16:05:08 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute the set of globalized functions.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_g
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    integrate_info
	    integrate_a)
   (export  (G! locals)))

;*---------------------------------------------------------------------*/
;*    G! ...                                                           */
;*    -------------------------------------------------------------    */
;*    The globalized function due to Cn property have already          */
;*    been computed during the Cn computation. Now, we just            */
;*    perform a fix-point iteration with the Ct property.              */
;*---------------------------------------------------------------------*/
(define (G! G/cn)
   (trace integrate "G/cn (dans G!): " (shape G/cn) #\Newline)
   (let loop ((stop? #f)
	      (stamp 0)
	      (Gs    G/cn))
      (if stop?
	  (begin
	     (for-each
	      (lambda (f)
		 (if (and (local? f)
			  (not (sfun/Iinfo-G? (local-value f)))
			  (not (variable? (sfun/Iinfo-L (local-value f)))))
		     (sfun/Iinfo-L-set! (local-value f)
					(sfun/Iinfo-owner (local-value f)))))
	      *phi*)
	     (trace integrate "G: " (shape Gs) #\Newline)
	     (trace (integrate 2)
		    "   " stamp " iteration(s) to fix point"
		    #\Newline)
	     Gs)
	  (let liip ((phi     *phi*)
		     (stop?   #t)
		     (Gs      Gs))
	     (if (null? phi)
		 (loop stop? (+fx stamp 1) Gs)
		 (let* ((f   (car phi))
			(fif (variable-value f)))
		    (let laap ((Ct       (sfun/Iinfo-Ct fif))
			       (stop?    stop?)
			       (Gs       Gs))
		       (if (null? Ct)
			   (liip (cdr phi) stop? Gs)
			   (let* ((g  (car Ct))
				  (gif (local-value g)))
			      (trace (integrate 2)
				     " Ct( " (shape f) ", " (shape g) " )"
				     #\Newline)
			      (cond
				 ((eq? f g)
				  (laap (cdr Ct) stop? Gs))
				 ((sfun/Iinfo-G? gif)
				  (laap (cdr Ct) stop? Gs))
				 ((sfun/Iinfo-G? fif)
				  (cond
				     ((not (variable? (sfun/Iinfo-L gif)))
				      (trace (integrate 2)
					     "   trying L.1( "
					     (shape f) ", " (shape g) " )"
					     #\Newline)
				      (sfun/Iinfo-L-set! gif f)
				      (laap (cdr Ct) #f Gs))
				     ((eq? (sfun/Iinfo-L gif) f)
				      (laap (cdr Ct) stop? Gs))
				     (else
				      (sfun/Iinfo-G?-set! gif #t)
				      (trace (integrate 2)
					     "   G.1( " (shape g) " )"
					     #\Newline)
				      (laap (cdr Ct) #f (cons g Gs)))))
				 ((not (variable? (sfun/Iinfo-L gif)))
				  (cond
				     ((variable? (sfun/Iinfo-L fif))
				      (sfun/Iinfo-L-set! gif (sfun/Iinfo-L fif))
				      (trace (integrate 2)
					     "   trying L.2( "
					     (shape (sfun/Iinfo-L fif)) ", "
					     (shape g) " )"
					     #\Newline)
				      (laap (cdr Ct) #f Gs))
				     (else
				      (let ((stop? (and
						    stop?
						    (integer? (sfun/Iinfo-istamp
							       fif))
						    (<=fx (sfun/Iinfo-istamp
							   fif)
							  stamp))))
					 (sfun/Iinfo-istamp-set! fif stamp)
					 (laap (cdr Ct) stop? Gs)))))
				 ((not (variable? (sfun/Iinfo-L fif)))
				  (trace (integrate 2)
					 "   trying L.3( "
					 (shape (sfun/Iinfo-L gif)) ", "
					 (shape f)
					 " )" #\Newline)
				  (sfun/Iinfo-L-set! fif (sfun/Iinfo-L gif))
				  (laap (cdr Ct) #f Gs))
				 ((eq? (sfun/Iinfo-L fif) (sfun/Iinfo-L gif))
				  (laap (cdr Ct) stop? Gs))
				 (else
				  (sfun/Iinfo-G?-set! gif #t)
				  (trace (integrate 2)
					 "   G.3( " (shape g) " )" #\Newline)
				  (laap (cdr Ct) #f (cons g Gs)))))))))))))
		       
      
