;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Foreign/cstruct.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun  6 12:23:13 1996                          */
;*    Last change :  Sun Apr  6 18:16:55 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C ptr accessors creations                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module foreign_cstruct
   (include "Tools/trace.sch")
   (import  type_tools
	    type_type
	    type_tools
	    type_env
	    tools_shape
	    tools_misc
	    foreign_ctype
	    foreign_access
	    module_module))
   
;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cstruct ...                               */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cstruct who::type)
   '())

;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cstruct* ...                              */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cstruct* who::type)
   (trace (expand 3) "make-ctype-accesses(cstruct*): " (shape what)
	  " " (shape who) #\Newline)
   (let* ((btype          (cstruct*-btype what))
	  (id             (type-id who))
	  (wid            (type-id what))
	  (bid            (type-id btype))
	  (id->bid        (symbol-append id '-> bid))
	  (bid->id        (symbol-append bid '-> id))
	  (bid?           (symbol-append id '?))
	  (bid?-bool      (symbol-append bid? '::bool))
	  (name           (type-name who))
	  (name-sans-$    (string-sans-$ name))
	  (cstruct        (cstruct*-cstruct what))
	  (cstruct-fields (cstruct-fields cstruct))
	  (sizeof         (string-append "*((" name-sans-$ ") 0)")))
      
      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (mk-id->bid)
	 `(macro ,bid ,id->bid (symbol ,id) "cobj_to_foreign"))

      (define (mk-bid->id)
	 (let ((mname (string-append "(" name-sans-$ ")FOREIGN_TO_COBJ")))
	    `(macro ,id ,bid->id (,bid) ,mname)))

      ;; the predicate
      (define (mk-bid?)
	 `(define-inline (,bid?-bool o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bid)
		 #f)))

      ;; equality (using ==)
      (define (mk-=id)
	 `(define-inline (,(symbol-append '= id '::bool)
			  ,(symbol-append 'o1 4dots id)
			  ,(symbol-append 'o2 4dots id))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; id-null?
      (define (mk-id-null?)
	 `(define-inline (,(symbol-append id '-null?::bool)
			  ,(symbol-append 'o 4dots id))
	     (pragma::bool ,(string-append "($1 == (" name-sans-$ ")0L)")
			   o)))
      
      ;; the user allocation form without initialization
      (define (mk-make-id)
	 `(define-inline (,(symbol-append 'make- id 4dots id))
	     (,(symbol-append 'pragma 4dots id)
	      ,(string-append "(" name-sans-$ ")GC_MALLOC( sizeof( "
			      sizeof
			      " ) )"))))
 
      ;; the user allocation form with initialization
      (define (mk-id)
	 (let ((formals-typed (map (lambda (f)
				      (let* ((f-id      (cadr f))
					     (f-type-id (car f))
					     (f-type    (use-type! f-type-id))
					     (af-type   (get-aliased-type
							 f-type)))
					 (if (cstruct? af-type)
					     (symbol-append f-id 4dots
							    f-type-id '*)
					     (symbol-append f-id 4dots
							    f-type-id))))
				   cstruct-fields))
	       (new           (gensym 'new)))
	    `(define-inline (,(symbol-append id 4dots id) ,@formals-typed)
		(let ((,(symbol-append new 4dots id)
		       (,(symbol-append 'make- id))))
		   ,@(map (lambda (f)
			     (let ((f-id (cadr f)))
				`(,(symbol-append id '- f-id '-set!) ,new
								     ,f-id)))
			  cstruct-fields)
		   ,new))))
      
      ;; getter and setter
      (define (getter-&-setter field)
	 (let* ((f-type-id       (car field))
		(f-type          (use-type! f-type-id))
		(af-type         (get-aliased-type f-type))
		(f-id            (cadr field))
		(f-name          (caddr field))
		(get-name        (symbol-append id '- f-id))
		(set-name        (symbol-append id '- f-id '-set!))
		(get-type-id     (if (cstruct? af-type)
				     (symbol-append f-type-id '*)
				     f-type-id))
		(struct-ref-fmt  (if (cstruct? af-type)
				     (string-append "&((((" name-sans-$
						    ")$1)->" f-name "))")
				     (string-append "(((" name-sans-$
						    ")$1)->" f-name ")")))
		(struct-set-fmt  (string-append "((((" name-sans-$
						")$1)->" f-name ")"))
		(struct-setv-fmt (if (cstruct? af-type)
				     " = (*($2)), BUNSPEC)"
				     " = ($2), BUNSPEC)"))) 
	    (list
	     `(define-inline (,(symbol-append get-name 4dots get-type-id)
			      ,(symbol-append 'o 4dots id))
		 (,(symbol-append 'pragma 4dots get-type-id)
		  ,struct-ref-fmt o))
	     `(define-inline (,(symbol-append set-name '::obj)
			      ,(symbol-append 'o 4dots id)
			      ,(symbol-append 'v 4dots get-type-id))
		 (pragma
		  ,(string-append struct-set-fmt struct-setv-fmt)
		  o
		  v)))))
      
      ;; getters and setters
      (define (getters-&-setters)
	 (let loop ((fields cstruct-fields)
		    (res   '()))
	    (if (null? fields)
		res
		(loop (cdr fields)
		      (append (getter-&-setter (car fields)) res)))))
      
      ;; we declare the coercion operations ...
      (produce-module-clause! `(foreign ,(mk-id->bid) ,(mk-bid->id)))
      ;; and the predicate
      (produce-module-clause! `(static (inline ,bid?-bool ::obj)))
      (produce-module-clause! `(pragma (,bid? (predicate-of ,wid))))

      (cons* (mk-make-id)
	     (mk-id)
	     (mk-=id)
	     (mk-id-null?)
	     (mk-bid?)
	     (getters-&-setters))))
      



