;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Expand/struct.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Oct  4 10:54:57 1995                          */
;*    Last change :  Tue Jun 11 10:45:39 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `define-struct' expansion                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_struct
   (import engine_param)
   (export (expand-struct ::obj ::procedure)))
 
;*---------------------------------------------------------------------*/
;*    expand-struct ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-struct x e)
   (match-case x
      ((?- ?name . ?slots)
       (match-define-structure! x)
       (let* ((len        (length slots))
	      (slots-name (map (lambda (s)
				  (match-case s
				     ((?name ?dv)
				      name)
				     ((? symbol?)
				      s)
				     (else
				      (error #f
					     "Illegal `define-struct' form"
					     x))))
			       slots))
	      (slots-val?  #f)
	      (slots-val   (map (lambda (s)
				   (match-case s
				      ((?- ?dv)
				       (set! slots-val? #t)
				       dv)
				      ((? symbol?)
				       ''())
				      (else
				       (error #f
					      "Illegal `define-struct' form"
					      x))))
				slots)))
          (cons
           'begin
           (cons
	    ;; on genere la fonction de create
            (e `(define-inline (,(symbol-append 'make- name) . init)
		   ,(if slots-val?
			`(if (pair? init)
			     (if (not (null? (cdr init)))
				 (error ',(symbol-append 'make- name)
					"Too many argument provided"
					init)
				 (make-struct ',name ,len (car init)))
			     (,name ,@slots-val))
			`(if (pair? init)
			     (if (not (null? (cdr init)))
				 (error ',(symbol-append 'make- name)
					"Too many argument provided"
					init)
				 (make-struct ',name ,len (car init)))
			     (make-struct ',name ,len '()))))
               e)
            (cons
             (e `(define-inline (,name ,@slots-name)
                    (let ((new (c-create-struct ',name ,len)))
                       ,@(let loop ((slots slots-name)
                                    (res   '()))
                            (if (null? slots)
                                res
                                (loop (cdr slots)
                                      (cons `(,(symbol-append name
                                                              '-
                                                              (car slots)
                                                              '-set!)
                                              new
                                              ,(car slots))
                                            res))))
		       new))
		e)
             (cons
              ;; on genere le predicat STRUCT?
              (e `(define-inline (,(symbol-append name '?) o)
                     (if (struct? o)
                         (eq? (struct-key o) ',name)
                         #f))
                 e)
              ;; on genere les fonctions d'access aux slots
              (let loop ((i     0)
                         (slots slots-name)
                         (res   '((unspecified))))
                 (if (=fx i len)
                     res
                     (let ((pr (car slots)))
                        (loop (+fx i 1)
                              (cdr slots)
                              (cons
                               ;; la lecture
                               (e
                                `(define-inline
                                    (,(symbol-append name '- pr) s)
                                    ,(if *unsafe-struct*
                                         `(struct-ref s ,i)
                                         `(if (eq? (struct-key s) ',name)
                                              (u-struct-ref s ,i)
                                              (error
                                               "struct-ref:not an instance of"
                                               ,(symbol->string name)
                                               s))))
                                e)
                               (cons
                                ;; l'ecriture
                                (e
                                 `(define-inline
                                     (,(symbol-append name '- pr '-set!) s v)
                                     ,(if *unsafe-struct*
                                          `(struct-set! s ,i v)
                                          `(if (eq? (struct-key s) ',name)
                                               (u-struct-set! s ,i v)
                                               (error
                                                "struct-set!:not an instance of"
                                                ,(symbol->string name)
                                                s))))
                                 e)
                                res))))))))))))
      (else
       (error #f "Illegal `define-struct' form" x))))
 
        
