;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cnst/cache.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 19 10:35:59 1995                          */
;*    Last change :  Tue Apr  8 13:30:53 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A cache to be able to recognize function call very fast.         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_cache
   (import  type_type
	    ast_var
	    ast_env
	    engine_param)
   (export  (start-cnst-cache!)
	    (stop-cnst-cache!)
	    *cnst-table-ref*
	    *cnst-table-set!*
	    *cons*
	    *btrue*
	    *bfalse*
	    *string->bstring*
	    *string->symbol*
	    *string->keyword*
	    *bool->bbool*
	    *make-fx-procedure*
	    *make-va-procedure*
	    *double->real*
	    *list->vector*
	    *vector-tag-set!*))

;*---------------------------------------------------------------------*/
;*    The cache registers definition                                   */
;*---------------------------------------------------------------------*/
(define *cache-started?*        #f)

(define *cnst-table-ref*        #f)
(define *cnst-table-set!*       #f)
(define *cons*                  #f)
(define *btrue*                 #f)
(define *bfalse*                #f)
(define *string->bstring*       #f)
(define *string->symbol*        #f)
(define *string->keyword*       #f)
(define *bool->bbool*           #f)
(define *make-fx-procedure*     #f)
(define *make-va-procedure*     #f)
(define *double->real*          #f)
(define *list->vector*          #f)
(define *vector-tag-set!*       #f)

;*---------------------------------------------------------------------*/
;*    start-cnst-cache! ...                                            */
;*---------------------------------------------------------------------*/
(define (start-cnst-cache!)
   (if (not *cache-started?*)
       (begin
	  (set! *cache-started?* #t)
	  (set! *cnst-table-ref* (find-global 'cnst-table-ref 'foreign))
	  (set! *cnst-table-set!* (find-global 'cnst-table-set! 'foreign))
	  (set! *cons* (find-global 'c-cons 'foreign))
	  (set! *btrue* (find-global 'btrue 'foreign))
	  (set! *bfalse* (find-global 'bfalse 'foreign))
	  (set! *string->bstring* (find-global 'string->bstring 'foreign))
	  (set! *string->symbol* (find-global 'c-string->symbol 'foreign))
	  (set! *string->keyword* (find-global 'c-string->keyword 'foreign))
	  (set! *bool->bbool* (find-global 'bool->bbool 'foreign))
	  (set! *make-fx-procedure* (find-global 'make-fx-procedure 'foreign))
	  (set! *make-va-procedure* (find-global 'make-va-procedure 'foreign))
	  (set! *double->real* (find-global 'double->real 'foreign))
	  (set! *list->vector* (find-global 'list->vector))
	  (set! *vector-tag-set!* (find-global 'vector-tag-set!))
	  #t)
       #t))

;*---------------------------------------------------------------------*/
;*    stop-cnst-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-cnst-cache!)
   (set! *string->bstring*    #f)
   (set! *string->symbol*     #f)
   (set! *string->keyword*    #f)
   (set! *bool->bbool*        #f)
   (set! *make-fx-procedure*  #f)
   (set! *make-va-procedure*  #f)
   (set! *double->real*       #f)
   (set! *cons*               #f)
   (set! *btrue*              #f)
   (set! *bfalse*             #f)
   #t)






