;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Ast/dump.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:26:21 1994                          */
;*    Last change :  Thu Apr  3 14:17:04 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast->sexp translator                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_dump
   (include "Tvector/tvector.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_args
	    tools_misc
	    engine_param)
   (export  (generic node->sexp ::node)))

;*---------------------------------------------------------------------*/
;*    node->sexp ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (node->sexp node::node))

;*---------------------------------------------------------------------*/
;*    node->sexp ::atom ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::atom)
   (if (null? (atom-value node))
       ''()
       (atom-value node)))

;*---------------------------------------------------------------------*/
;*    node->sexp ::var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::var)
   (shape (var-variable node)))
		     
;*---------------------------------------------------------------------*/
;*    node->sexp ::closure ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::closure)
   `(function ,(shape (closure-variable node))))
 
;*---------------------------------------------------------------------*/
;*    node->sexp ::kwote ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::kwote)
   (let ((value (kwote-value node)))
      (if (a-tvector? value)
	  `(quote ,(a-tvector (shape (a-tvector-type value))
			      (a-tvector-vector value)))
	  `(quote ,value))))
       
;*---------------------------------------------------------------------*/
;*    node->sexp ::sequence ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::sequence)
   `(begin
       ,@(map node->sexp (sequence-nodes node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::app ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::app)
   `(,(node->sexp (app-fun node)) ,@(map node->sexp (app-args node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::app-ly ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::app-ly)
   `(apply ,(node->sexp (app-ly-fun node)) ,(node->sexp (app-ly-arg node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::funcall ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::funcall)
   `(,(case (funcall-strength node)
	 ((light)
	  'funcall-l)
	 ((elight)
	  'funcall-el)
	 (else
	  'funcall))
     ,(node->sexp (funcall-fun node))
     ,@(map node->sexp (funcall-args node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::pragma ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::pragma)
   (let ((p (if (pragma-side-effect? node) 'pragma 'free-pragma)))
      `(,(if *type-shape?*
	     (symbol-append p 4dots (type-id (node-type node)))
	     p)
	,(pragma-format node)
	,@(map node->sexp (pragma-args node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::cast ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::cast)
   (with-access::cast node (type arg)
      `(,(symbol-append 'cast 4dots (type-id type)) ,(node->sexp arg))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::setq ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::setq)
   `(set! ,(node->sexp (setq-var node)) ,(node->sexp (setq-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::conditional ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::conditional)
   `(if ,(node->sexp (conditional-test node))
	,(node->sexp (conditional-true node))
	,(node->sexp (conditional-false node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::fail ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::fail)
   `(failure ,(node->sexp (fail-proc node))
	     ,(node->sexp (fail-msg node))
	     ,(node->sexp (fail-obj node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::select ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::select)
   `(case ,(node->sexp (select-test node))
       ,@(map (lambda (clause) `(,(car clause) ,(node->sexp (cdr clause))))
	      (select-clauses node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::let-fun ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::let-fun)
   `(labels ,(map (lambda (fun)
			 `(,(shape fun)
			   ,(args-list->args*
			     (map shape (sfun-args (local-value fun)))
			     (sfun-arity (local-value fun)))
			   ,(node->sexp (sfun-body (local-value fun)))))
		  (let-fun-locals node))
       ,(node->sexp (let-fun-body node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::let-var ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::let-var)
   `(let ,(map (lambda (b)
		  `(,(shape (car b)) ,(node->sexp (cdr b))))
	       (let-var-bindings node))
       ,(node->sexp (let-var-body node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::set-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::set-ex-it)
   `(set-exit ,(node->sexp (set-ex-it-var node))
	      ,(node->sexp (set-ex-it-body node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::jump-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::jump-ex-it)
   `(jump-exit ,(node->sexp (jump-ex-it-exit node))
	       ,(node->sexp (jump-ex-it-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::make-box ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::make-box)
   `(make-box ,(node->sexp (make-box-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::box-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::box-ref)
   `(box-ref ,(node->sexp (box-ref-var node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::box-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::box-set!)
   `(box-set! ,(node->sexp (box-set!-var node))
	      ,(node->sexp (box-set!-value node))))
		  
	

     
   
