#
# hwclock.sh	Set and adjust the CMOS clock, according to the UTC
#		setting in /etc/default/rcS (see also rcS(5)).
#
# Version:	@(#)hwclock.sh  2.00  14-Dec-1998  miquels@cistron.nl
#

. /etc/default/rcS
[ "$GMT" = "-u" ] && GMT="--utc"

case "$1" in
	start)
		if [ ! -f /etc/adjtime ]
		then
			echo "0.0 0 0.0" > /etc/adjtime
		fi
		hwclock --adjust $GMT
		hwclock --hctosys $GMT
		#
		#	Now that /usr/lib/zoneinfo should be available,
		#	announce the local time.
		#
		if [ "$VERBOSE" != no ]
		then
			echo
			echo "Local time: `date`"
			echo
		fi
		;;
	stop|restart|reload)
		[ "$GMT" = "-u" ] && GMT="--utc"
		hwclock --systohc $GMT
		if [ "$VERBOSE" != no ]
		then
			echo "CMOS clock updated to `date`."
		fi
		;;
	show)
		hwclock --show $GMT
		;;
	*)
		echo "Usage: hwclock.sh {start|stop|reload|show}" >&2
		echo "       start sets kernel clock from CMOS clock" >&2
		echo "       stop and reload set CMOS clock from kernel clock" >&2
		exit 1
		;;
esac

