/*
	wipe.c - animate wipe

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static int wipeW, wipeH, windowW, windowH;

#if defined(__STDC__) || defined(__cplusplus)
static void wipeImage(int mode)	/* Wipe in,Wipe out */
#else
static void wipeImage(mode)
int mode;
#endif
{
Pixmap		pic;
XGCValues	gcv;
GC		gc;
int		sx,sy,dx,dy,w,h,drawWidth,drawHeight;
int		src_x,src_y,dst_x,dst_y,size;

	src_x = wipeW / 2;
	src_y = wipeH / 2;
	dst_x = windowW / 2;
	dst_y = windowH / 2;
	drawWidth  = (wipeW > windowW ? windowW : wipeW);
	drawHeight = (wipeH > windowH ? windowH : wipeH);

	if(mode){ /* WIPE IN */
		gcv.function = GXcopy;
		gc = XCreateGC(theDisp,theWindow,GCFunction,&gcv );

		if((pic = XCreatePixmap(
								theDisp,
								theWindow,
								wipeW,wipeH,
								DefaultDepth(theDisp,theScreenNumber))
								) == (Pixmap)0){
			fprintf(stderr,"Can't create Pixmap. Abort.\n");
			goodbyekiss();
		}

		XPutImage(theDisp,pic,gc,theImage,0,0,0,0,wipeW,wipeH);

		for(size = app_data.wipeSteps;
			size < (drawWidth > drawHeight ? drawWidth : drawHeight);
			size += app_data.wipeSteps)	{

			sx = src_x - (size / 2);
			sy = src_y - (size / 2);
			dx = dst_x - (size / 2);
			dy = dst_y - (size / 2);
			w = size;
			h = app_data.wipeSteps;
			XCopyArea(theDisp,pic,theWindow,gc,sx,sy,w,h,dx,dy);

			sx = src_x + (size / 2) - app_data.wipeSteps;
			sy = src_y - (size / 2);
			dx = dst_x + (size / 2) - app_data.wipeSteps;
			dy = dst_y - (size / 2);
			w = app_data.wipeSteps;
			h = size;
			XCopyArea(theDisp,pic,theWindow,gc,sx,sy,w,h,dx,dy);

			sx = src_x + (size / 2) - size;
			sy = src_y + (size / 2) - app_data.wipeSteps;
			dx = dst_x + (size / 2) - size;
			dy = dst_y + (size / 2) - app_data.wipeSteps;
			w = size;
			h = app_data.wipeSteps;
			XCopyArea(theDisp,pic,theWindow,gc,sx,sy,w,h,dx,dy);

			sx = src_x - (size / 2);
			sy = src_y + (size / 2) - size;
			dx = dst_x - (size / 2);
			dy = dst_y + (size / 2) - size;
			w = app_data.wipeSteps;
			h = size;
			XCopyArea(theDisp,pic,theWindow,gc,sx,sy,w,h,dx,dy);

			myusleep(app_data.wipeTicks);
			if(gotSomeAction == True)
				break;

		}
		XFreeGC(theDisp,gc);
		XFreePixmap(theDisp,pic);

	}

	else{ /* WIPE OUT */
		for(size = (drawWidth > drawHeight ? drawWidth : drawHeight);
			size > 0;
			size -= app_data.wipeSteps	){

			dx = dst_x - (size / 2);
			dy = dst_y - (size / 2);
			w = size;
			h = app_data.wipeSteps;
			XClearArea(theDisp,theWindow,dx,dy,w,h,False);

			dx = dst_x + (size / 2) - app_data.wipeSteps;
			dy = dst_y - (size / 2);
			w = app_data.wipeSteps;
			h = size;
			XClearArea(theDisp,theWindow,dx,dy,w,h,False);

			dx = dst_x + (size / 2) - size;
			dy = dst_y + (size / 2) - app_data.wipeSteps;
			w = size;
			h = app_data.wipeSteps;
			XClearArea(theDisp,theWindow,dx,dy,w,h,False);

			dx = dst_x - (size / 2);
			dy = dst_y + (size / 2) - size;
			w = app_data.wipeSteps;
			h = size;
			XClearArea(theDisp,theWindow,dx,dy,w,h,False);

			myusleep(app_data.wipeTicks);
			if(gotSomeAction == True)
				break;
		}

		XClearArea(
					theDisp,
					theWindow,
					dst_x - app_data.wipeSteps / 2,
					dst_y - app_data.wipeSteps / 2,
					app_data.wipeSteps,
					app_data.wipeSteps,
					False );
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xwipeshow(char *fname)
#else
ActionStatus xwipeshow(fname)
char *fname;
#endif
{
	wipeW   = gim.subImageList->width;
	wipeH   = gim.subImageList->height;
	windowW = windowWidth;
	windowH = windowHeight;

	PreDisplay();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	wipeImage(True);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxwipeshow(char *fname)
#else
void postxwipeshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	wipeImage(False);
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xwipeshow24(char *fname)
#else
ActionStatus xwipeshow24(fname)
char *fname;
#endif
{
	wipeW   = gim.subImageList->width;
	wipeH   = gim.subImageList->height;
	windowW = windowWidth;
	windowH = windowHeight;

	PreDisplay2();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	wipeImage(True);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxwipeshow24(char *fname)
#else
void postxwipeshow24(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();
}

