/* canvas definition */

typedef struct {
	ltgenericd g;
	tdisplay dpy;		/* current display */
    Display *xdpy;       /* X Display */
    Window win;         /* X window */
	Drawable buf;		/* either the window or the pixmap */
    GC gc;              /* X graphics context, for scrolling, etc... */
    GC gcerase;         /* X graphics context, for clearing areas */
    GC gcpage;          /* for drawing page boundaries */
    GC gcdrag;          /* for drawing drag boxes */
    GC gcdragsolid;     /* for drawing solid drag boxes */
	GC xgc;				/* for drawing user stuff, is changed to match
							the context passed */
	tcontext tgc;		/* context matching xgc, for knowing what to change */
    int scr;            /* X screen */
    int depth;          /* X window display depth */
    unsigned long bg;   /* background pixel value */
    unsigned long fg;   /* foreground pixel value */
    unsigned long blk;  /* black pixel value */
    unsigned long wht;  /* white pixel value */
    int xpos,ypos;    /* x and y position of top left corner, for scrolling */
          /* ^^^ these change with magnification */
    int cw, ch;       /* width and height of canvas window */
    int magx, magy;     /* x and y magnification levels,
                            ==1,2,4,8,etc. or -2,-4,-8,etc.
                            1=normal, 2=double, -2=half, etc... */
	int buffer;			/* 1 if we will use a buffer */
    Pixmap back;        /* X window pixmap for back display (if possible) */
    int ax,ay,aw,ah;  /* area we are drawing to, draw requests outside this
							area will not be honored */
	int clipping;
	int dx, dy, dw, dh;	/* area that we must draw to, for add area */
	int areaset;		/* 1 if the area has been set, for add area */
    Xv_window pw;       /* Xview Paint window */
    Canvas cvs;         /* Xview canvas */
	int scrollx, scrolly;
    Scrollbar x, y;     /* 2 scrollbars */
        /* ^^^ VIEW_START & OBJECT_LEN change with magnification */
    Frame parent;       /* xview parent frame */
	/* real are for the normalized size, pagew,h is for current */
    int realpagew,realpageh;  /* in screen pixels */
    int pagew,pageh;  /* in screen pixels */
           /* ^^^ these change with magnification */
    int cellw,cellh;  /* size of one cell, for scrolling */
    int cvsw,cvsh;      /* in pages */
    int pages;      /* 1 if pages should be shown */
	int oktodraw;	/* 1 if first expose event has happened */
	int (*do_events)();
	int printing;	/* 1 if we are printing on this canvas */
	tp_type printtype;	/* 0 for postscript, 1 for PICT2 */
	FILE *printfile;	/* file we are printing to */
	char *printname;	/* file name we are printing to */
	void (*do_timer)();
	} ltcanvasd, *ltcanvas;

typedef struct CANVAS_LIST {
	ltcanvas c;
	struct CANVAS_LIST *next;
	} canvas_listd, *canvas_list;
