/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInMFInt32.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFInt32;

public class EventInMFInt32 extends EventIn
{
  public void setValue (int[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null)
      throw new IllegalArgumentException ();

    ((MFInt32) eventin_).setValue (value);

    sendEvent ();

    scene_.redraw ();
  }

  public void set1Value (int index, int value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (index < 0 || index >= ((MFInt32) eventin_).getValueCount ())
      throw new IllegalArgumentException ();

    int[] data = ((MFInt32) eventin_).getValueData ();
    data[index] = value;

    sendEvent ();

    scene_.redraw ();
  }
}
