/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.DrawingSequenceOwner;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public abstract class DrawingSequence
extends Image
implements Target,
Codable {
    DrawingSequenceOwner owner;
    String name;
    Timer animateTimer;
    int currentFrameNumber;
    int frameCount;
    int frameRate;
    int playbackMode;
    boolean animating;
    boolean resetOnStart;
    boolean resetOnStop;
    boolean bounceForward = true;
    public static final int FORWARD = 0;
    public static final int FORWARD_LOOP = 1;
    public static final int BACKWARD = 2;
    public static final int BACKWARD_LOOP = 3;
    public static final int BOUNCE = 4;
    static final int MIN_FRAME_RATE = 1;
    static final String OWNER_KEY = "owner";
    static final String NAME_KEY = "name";
    static final String CURRENTFRAME_KEY = "currentFrameNumber";
    static final String FRAMECOUNT_KEY = "frameCount";
    static final String FRAME_RATE_KEY = "frameRate";
    static final String PLAYBACKMODE_KEY = "playbackMode";
    static final String ANIMATING_KEY = "animating";
    static final String RESETONSTART_KEY = "resetOnStart";
    static final String RESETONSTOP_KEY = "resetOnStop";
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String NEXT_FRAME = "nextFrame";

    public DrawingSequence() {
        this(null);
    }

    public DrawingSequence(DrawingSequenceOwner drawingSequenceOwner) {
        this.owner = drawingSequenceOwner;
        this.frameRate = 1;
        this.playbackMode = 0;
    }

    public void setOwner(DrawingSequenceOwner drawingSequenceOwner) {
        this.owner = drawingSequenceOwner;
    }

    public DrawingSequenceOwner owner() {
        return this.owner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String name() {
        return this.name;
    }

    public void performCommand(String string, Object object) {
        if (START.equals(string)) {
            this.start();
            return;
        }
        if (STOP.equals(string)) {
            this.stop();
            return;
        }
        if (NEXT_FRAME.equals(string)) {
            this.nextFrame();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    public void start() {
        if (this.resetOnStart) {
            this.reset();
        }
        this.animating = true;
        if (this.animateTimer == null) {
            if (this.owner != null) {
                this.owner.drawingSequenceFrameChanged(this);
            }
            this.animateTimer = new Timer(this, NEXT_FRAME, this.frameRate);
            this.animateTimer.start();
        }
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void stop() {
        this.animating = false;
        if (this.animateTimer != null) {
            this.animateTimer.stop();
            this.animateTimer = null;
        }
        if (this.resetOnStop) {
            this.reset();
        }
    }

    public void reset() {
        if (this.playbackMode == 0 || this.playbackMode == 1 || this.playbackMode == 4) {
            this.currentFrameNumber = 0;
            return;
        }
        this.currentFrameNumber = this.frameCount - 1;
    }

    public void setFrameCount(int n) {
        if (n > 0) {
            this.frameCount = n;
            return;
        }
        this.frameCount = 0;
    }

    public int frameCount() {
        return this.frameCount;
    }

    public void setCurrentFrameNumber(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.frameCount) {
            n = this.frameCount - 1;
        }
        this.currentFrameNumber = n;
    }

    public int currentFrameNumber() {
        return this.currentFrameNumber;
    }

    public void setFrameRate(int n) {
        this.frameRate = n > 1 ? n : 1;
        if (this.animateTimer != null) {
            this.animateTimer.setDelay(this.frameRate);
        }
    }

    public int frameRate() {
        return this.frameRate;
    }

    public void setPlaybackMode(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        this.playbackMode = n;
        this.reset();
    }

    public int playbackMode() {
        return this.playbackMode;
    }

    public void setResetOnStart(boolean bl) {
        this.resetOnStart = bl;
    }

    public boolean doesResetOnStart() {
        return this.resetOnStart;
    }

    public void setResetOnStop(boolean bl) {
        this.resetOnStop = bl;
    }

    public boolean doesResetOnStop() {
        return this.resetOnStop;
    }

    public boolean doesLoop() {
        return this.playbackMode == 1 || this.playbackMode == 3 || this.playbackMode == 4;
    }

    public boolean nextFrame() {
        boolean bl = true;
        if (this.frameCount == 0) {
            this.stop();
            throw new InconsistencyException("Frame count is 0");
        }
        if (this.playbackMode == 0 || this.playbackMode == 1) {
            ++this.currentFrameNumber;
            if (this.currentFrameNumber >= this.frameCount) {
                if (this.playbackMode != 1) {
                    this.currentFrameNumber = this.frameCount - 1;
                    bl = false;
                } else {
                    this.currentFrameNumber = 0;
                }
            }
        } else if (this.playbackMode == 4) {
            bl = true;
            if (this.frameCount == 1) {
                this.currentFrameNumber = 0;
            } else if (this.bounceForward) {
                ++this.currentFrameNumber;
                if (this.currentFrameNumber >= this.frameCount) {
                    this.bounceForward = false;
                    this.currentFrameNumber -= 2;
                }
            } else if (!this.bounceForward) {
                --this.currentFrameNumber;
                if (this.currentFrameNumber < 0) {
                    this.bounceForward = true;
                    this.currentFrameNumber += 2;
                }
            }
        } else {
            --this.currentFrameNumber;
            if (this.currentFrameNumber < 0) {
                if (this.playbackMode != 3) {
                    this.currentFrameNumber = 0;
                    bl = false;
                } else {
                    this.currentFrameNumber = this.frameCount - 1;
                }
            }
        }
        if (bl) {
            if (this.owner != null) {
                this.owner.drawingSequenceFrameChanged(this);
            }
            return true;
        }
        this.stop();
        if (this.owner != null) {
            this.owner.drawingSequenceCompleted(this);
        }
        return false;
    }

    public abstract int width();

    public abstract int height();

    public abstract void drawAt(Graphics var1, int var2, int var3);

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.DrawingSequence", 1);
        classInfo.addField(OWNER_KEY, (byte)18);
        classInfo.addField(NAME_KEY, (byte)16);
        classInfo.addField(CURRENTFRAME_KEY, (byte)8);
        classInfo.addField(FRAMECOUNT_KEY, (byte)8);
        classInfo.addField(FRAME_RATE_KEY, (byte)8);
        classInfo.addField(PLAYBACKMODE_KEY, (byte)8);
        classInfo.addField(ANIMATING_KEY, (byte)0);
        classInfo.addField(RESETONSTART_KEY, (byte)0);
        classInfo.addField(RESETONSTOP_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(OWNER_KEY, (Codable)this.owner);
        encoder.encodeString(NAME_KEY, this.name);
        encoder.encodeInt(CURRENTFRAME_KEY, this.currentFrameNumber);
        encoder.encodeInt(FRAMECOUNT_KEY, this.frameCount);
        encoder.encodeInt(FRAME_RATE_KEY, this.frameRate);
        encoder.encodeInt(PLAYBACKMODE_KEY, this.playbackMode);
        encoder.encodeBoolean(ANIMATING_KEY, this.animating);
        encoder.encodeBoolean(RESETONSTART_KEY, this.resetOnStart);
        encoder.encodeBoolean(RESETONSTOP_KEY, this.resetOnStop);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.owner = (DrawingSequenceOwner)decoder.decodeObject(OWNER_KEY);
        this.name = decoder.decodeString(NAME_KEY);
        this.currentFrameNumber = decoder.decodeInt(CURRENTFRAME_KEY);
        this.frameCount = decoder.decodeInt(FRAMECOUNT_KEY);
        this.frameRate = decoder.decodeInt(FRAME_RATE_KEY);
        this.playbackMode = decoder.decodeInt(PLAYBACKMODE_KEY);
        this.animating = decoder.decodeBoolean(ANIMATING_KEY);
        this.resetOnStart = decoder.decodeBoolean(RESETONSTART_KEY);
        this.resetOnStop = decoder.decodeBoolean(RESETONSTOP_KEY);
    }

    public void finishDecoding() throws CodingException {
        if (this.animating) {
            this.animating = false;
            this.start();
        }
    }
}

