/****************************************************************/
/*  dsputil.h							*/
/* DSP utility functions for Csound - dispfft and pvoc		*/
/* Header file - just declarations				*/
/* 20apr90 dpwe							*/
/****************************************************************/

#define     SPTS    (16)    /* SINC TABLE: How many points in each lobe */
#define     SPDS    (6)     /*	 (was 8)   How many sinc lobes to go out */
#define     SBW     0.9     /* To compensate for short sinc, reduce bandw */

#ifndef PI
#define PI	(3.14159265358979323846)
#endif
#ifndef TWOPI
#define TWOPI	(6.28318530717958647692)
#endif
#ifndef PI_F
#define PI_F	(3.14159265358979323846f)
#endif
#ifndef TWOPI_F
#define TWOPI_F	(6.28318530717958647692f)
#endif

/* Predeclare static supporting functions */

void CopySamps(float *, float *, long);
float *MakeBuf(long);
void FillHalfWin(float *, long, float, int);
float *MakeHalfWin(long, float, int);
void UnpackReals(float *, long);
void PackReals(float *, long);
void Rect2Polar(float *, long);
void Polar2Rect(float *, long);
void Lin2DB(float *, long);
void DB2Lin(float *, long);
float maskPhs(float);
void UnwrapPhase(float *, long, float *);
void RewrapPhase(float *, long, float *);
void PhaseToFrq(float *, long, float, float);
void FrqToPhase(float *, long, float, float, float);
void FetchIn(float *, float *, long, float);
void FillFFTnConj(float *, long, float, int);
void ApplyHalfWin(float *, float *, long);
void addToCircBuf(float *, float *, long, long, long);
void writeClrFromCircBuf(float *, float *, long, long, long);
void FixAndAdd(float *, short *, long);
long NumFrames(long, long, long);
long NumSampls(long, long, long);
void FloatAndCopy(short *, float *, long);
void WriteOut(float *, float **, long);
void UDSample(float *, float, float *, long, long, float);
void MakeSinc(void);
void DestroySinc(void);	  /* relase the lookup table */
float SincIntp(float); /* return interpolated sinc - not used */
void PreWarpSpec(float *, long, float);

