/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		OSCond.h

	Contains:	A simple condition variable abstraction
	
	$Log: OSCond.h,v $
	Revision 1.2  1999/02/19 23:06:12  ds
	Created
		

*/

#ifndef _OSCOND_H_
#define _OSCOND_H_

#if !__PTHREADS__
#include "mycondition.h"
#else
#include <pthread.h>
#endif

#include "OSMutex.h"
#include "MyAssert.h"

class OSCond 
{
	public:

		OSCond();
		~OSCond();
		
		inline void		Broadcast();
		inline void 	Signal();
		inline void 	Wait(OSMutex* inMutex, SInt32 inTimeoutInMilSecs = 0);

	private:

#if !__PTHREADS__
		mycondition_t 		fCondition;
#else
		pthread_cond_t		fCondition;
		void				TimedWait(pthread_mutex_t* inMutex, SInt32 inTimeoutInMilSecs);
#endif
};

inline void OSCond::Wait(OSMutex* inMutex, SInt32 inTimeoutInMilSecs)
{ 
#if !__PTHREADS__
	Assert(fCondition != NULL);
	mycondition_wait(fCondition, inMutex->fMutex, inTimeoutInMilSecs);
#else
	this->TimedWait(&inMutex->fMutex, inTimeoutInMilSecs);
#endif
}

inline void OSCond::Signal()
{
#if !__PTHREADS__
	Assert(fCondition != NULL)
	mycondition_signal(fCondition);
#else
	pthread_cond_signal(&fCondition);
#endif
}

inline void OSCond::Broadcast()
{
#if !__PTHREADS__
	Assert(fCondition != NULL);
	mycondition_broadcast(fCondition);
#else
	pthread_cond_broadcast(&fCondition);
#endif
}


#endif //_OSCOND_H_