/* $Id: nntp.c,v 1.7 1999/11/10 04:29:14 xfmail Exp $ */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <cfgfile.h>
#include <connectionManager.h>

extern cfgfile Config;
extern class connectionManager ConMan;

static char response[255];
static int nntpsock = -1;
FILE *nntp_in = NULL;
FILE *nntp_out = NULL;


#if STDC_HEADERS || defined(USE_STDARG)
int nntp_command(char *fmt, ...)
#else
int nntp_command(char *fmt, va_dcl
                 va_list)
#endif
{
    int res;
    char buf[255];
    va_list ap;

#if STDC_HEADERS || defined(USE_STDARG)
    va_start(ap, fmt);
#else
    va_start(ap);
#endif

    if(fmt) {
        snprintf(response, sizeof(response), fmt, ap);

        if(logging & LOG_NNTP) {
            if(!strncasecmp(response, "AUTHINFO PASS ", 14))
                display_msg(MSG_LOG, "nntp", "-> AUTHINFO PASS ******");
            else
                display_msg(MSG_LOG, "nntp", "-> %-.127s", response);
        }

        if(putline(response, nntp_out) == -1)
            return -1;
    }

    if(getline(response, sizeof(response), nntp_in) == NULL)
        return -1;

    if(logging & LOG_NNTP)
        display_msg(MSG_LOG, "nntp", "<- %-.127s", response);

    res = -1;
    sscanf(response, "%d%s", &res, buf);

    if(res == -1) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        return -1;
    }

    return res;
}

void nntp_close() {

    ConMan.del_cinfo(nntpsock);

    if(nntp_in != NULL)
        fclose(nntp_in);

    nntp_in = NULL;
    nntp_out = NULL;
}

void nntp_end() {
    if(nntp_command("QUIT") != 205)
        display_msg(MSG_WARN, "nntp", "%-.127s", response);

    nntp_close();
}

int nntp_init() {
    char buf[255];
    int res, authusr = 0, authpass = 0;

    if(nntpsock != -1) {
        display_msg(MSG_WARN, "nntp", "NNTP busy");
        return -1;
    }

    strcpy(buf, Config.getString(conf_name, "nntphost", "news"));
    nntpsock =
    ConMan.host_connect(buf, Config.getString(conf_name, "nntport", "119"),
                 NULL); if(nntpsock == -1)
        return -1;

    if((nntp_in = fdopen(nntpsock, "r+")) == NULL) {
        display_msg(MSG_WARN, "nntp", "fdopen failed");
        nntp_close();
        return -1;
    }

    nntp_out = nntp_in;

    if(Config.getInt(conf_name, "nntpauth", 0)) {
        if((strlen(Config.getString(conf_name, "nntpasswd", "")) < 1)
           && (Config.getInt(conf_name, "nntpstorpwd", 0) == 0))
            nntp_account();
        if(strlen(Config.getString(conf_name, "nntpuser", user_n)))
            authusr = 1;
        authpass = 1;
    }
    switch(nntp_command(NULL)) {
        case 200:
            break;

        case 380:
        case 480:
            authusr = 1;
            break;

        case 381:
            authpass = 1;
            break;

        default:
            display_msg(MSG_WARN, "nntp", "%-.127s", response);
            nntp_close();
            return -1;
            break;
    }

    nntp_user:
    if(authusr) {
        if(strlen(Config.getString(conf_name, "nntpuser", user_n)) == 0)
            nntp_account();
        switch(nntp_command
               ("AUTHINFO USER %s",
                Config.getString(conf_name, "nntpuser", user_n))) {
            case 381:
                authpass = 1;
                break;

            case 281:
                authpass = 0;
                break;

            default:
                display_msg(MSG_WARN, "nntp", "%-.127s", response);
                nntp_close();
                return -1;
                break;
        }
    }

    if(authpass) {
        if(strlen(Config.getString(conf_name, "nntpasswd", "")) == 0)
            nntp_account();
        switch(nntp_command
               ("AUTHINFO PASS %s",
                Config.getString(conf_name, "nntpasswd", ""))) {
            case 281:
                break;

            case 482:
                authpass = 0;
                authusr = 1;
                goto nntp_user;
                break;

            default:
                nntp_account();
                if(nntp_command
                   ("AUTHINFO PASS %s",
                    Config.getString(conf_name, "nntpasswd", "")) != 281) {
                    display_msg(MSG_WARN, "nntp", "%-.127s", response);
                    nntp_close();
                    return -1;
                }
                break;
        }
    }

    if(((res = nntp_command("MODE READER")) != 200) && (res != 500)) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_close();
        return -1;
    }

    return 0;
}

int nntp_send_message(struct _mail_msg *msg) {
    struct _head_field *hf;

    if(msg->header->News == NULL)
        return 0;

    if(nntp_init() == -1)
        return -1;

    if(nntp_command("POST") != 340) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_end();
        return -1;
    }

    if((hf = find_field(msg, "X-Mailer")) != NULL)
        strcpy(hf->f_name, "X-Newsreader");

    if(smtp_message(msg, nntp_out) == -1) {
        nntp_end();
        if(hf != NULL)
            strcpy(hf->f_name, "X-Mailer");
        return -1;
    }

    if(hf != NULL)
        strcpy(hf->f_name, "X-Mailer");

    if(nntp_command(".") != 240) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_end();
        return -1;
    }

    nntp_end();
    return 0;
}

int is_newsgroup_addr(struct _mail_addr *addr, int strict) {
    char *p;

    if(addr->name || addr->comment || addr->pgpid)
        return 0;

    if(!strncmp(addr->addr, "#news.", 6))
        return 1;

    if(strict || !islower(*addr->addr))
        return 0;

    p = addr->addr + 1;
    while(*p) {
        if(!islower(*p) && !isdigit(*p) &&
           (*p != '-') && (*p != '_') && (*p != '.'))
            return 0;

        if(*p == '.') {
            if((p[1] == '.') || (p[1] == '\0') || (p[-1] == '.'))
                return 0;
        }

        p++;
    }

    return 1;
}

struct _news_addr *expand_news_addr_list(struct _mail_addr *addr,
                                         int strict) {
    struct _news_addr *ng, *naddr = NULL;

    while(addr) {
        if(is_newsgroup_addr(addr, strict)) {
            if((ng = get_news_addr(addr->addr)) != NULL) {
                ng->next = naddr;
                naddr = ng;
            }
        }
        addr = addr->next_addr;
    }

    return naddr;
}
