/* OS-dependent support for fine-grained timer.
** Copyright (c) 1995 by Olin Shivers.
**
** We return the current time in seconds and sub-second "ticks" where the 
** number of ticks/second is OS dependent (and is defined in time_dep.scm).
** This definition works on any BSD Unix with the gettimeofday() 
** microsecond-resolution timer.
*/

#include <errno.h>
#include <sys/time.h>
#include "scheme48.h"
#include "../time1.h"

/* Sux because it's dependent on 32-bitness. */
#define hi8(i)  (((i)>>24) & 0xff)
#define lo24(i) ((i) & 0xffffff)
#define comp8_24(hi, lo) (((hi)<<24) + (lo))

scheme_value time_plus_ticks(int *hi_secs, int *lo_secs,
			     int *hi_ticks, int *lo_ticks)
{
    struct timeval t;
    struct timezone tz;

    if( gettimeofday(&t, &tz) ) return ENTER_FIXNUM(errno);

    {   long int secs  = t.tv_sec;
	long int ticks = t.tv_usec;
     
        *hi_secs  = hi8(secs);
        *lo_secs  = lo24(secs);
        *hi_ticks = hi8(ticks);
        *lo_ticks = lo24(ticks);
        }

    return SCHFALSE;
    }
